
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bill", lb=0)  # hours worked by Bill
x1 = m.addVar(name="hours_worked_by_Mary", lb=0)  # hours worked by Mary
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)  # hours worked by Hank

# Define the objective function
m.setObjective(9.62*x0 + 6.74*x1 + 7.61*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9.76*x0 <= 125)
m.addConstr(4.81*x0 <= 97)
m.addConstr(10.28*x0 <= 133)
m.addConstr(0.62*x0 <= 112)
m.addConstr(5.35*x0 <= 111)

m.addConstr(11.19*x1 <= 125)
m.addConstr(10.91*x1 <= 97)
m.addConstr(0.89*x1 <= 133)
m.addConstr(11.77*x1 <= 112)
m.addConstr(8.39*x1 <= 111)

m.addConstr(9.05*x2 <= 125)
m.addConstr(7.87*x2 <= 97)
m.addConstr(11.33*x2 <= 133)
m.addConstr(8.79*x2 <= 112)
m.addConstr(11.28*x2 <= 111)

m.addConstr(4.81*x0 + 10.91*x1 >= 18)
m.addConstr(4.81*x0 + 10.91*x1 + 7.87*x2 >= 18)
m.addConstr(10.28*x0 + 0.89*x1 + 11.33*x2 >= 34)
m.addConstr(0.62*x0 + 8.79*x2 >= 14)
m.addConstr(11.77*x1 + 8.79*x2 >= 37)
m.addConstr(5.35*x0 + 8.39*x1 + 11.28*x2 >= 28)

m.addConstr(11.19*x1 + 9.05*x2 <= 75)
m.addConstr(9.76*x0 + 11.19*x1 + 9.05*x2 <= 75)
m.addConstr(4.81*x0 + 7.87*x2 <= 51)
m.addConstr(4.81*x0 + 10.91*x1 + 7.87*x2 <= 51)

m.addConstr(10.28*x0 + 11.33*x2 <= 83)
m.addConstr(0.89*x1 + 11.33*x2 <= 64)
m.addConstr(10.28*x0 + 0.89*x1 + 11.33*x2 <= 64)

m.addConstr(0.62*x0 + 8.79*x2 <= 38)
m.addConstr(11.77*x1 + 8.79*x2 <= 86)
m.addConstr(0.62*x0 + 11.77*x1 + 8.79*x2 <= 86)

m.addConstr(5.35*x0 + 8.39*x1 <= 105)
m.addConstr(5.35*x0 + 11.28*x2 <= 110)
m.addConstr(5.35*x0 + 8.39*x1 + 11.28*x2 <= 110)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
else:
    print("The model is infeasible")
