
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
apples = model.addVar(vtype=GRB.INTEGER, name="apples")
cantaloupes = model.addVar(vtype=GRB.CONTINUOUS, name="cantaloupes")
blueberry_pies = model.addVar(vtype=GRB.CONTINUOUS, name="blueberry_pies")
apple_pies = model.addVar(vtype=GRB.CONTINUOUS, name="apple_pies")
ravioli = model.addVar(vtype=GRB.INTEGER, name="ravioli")
milkshakes = model.addVar(vtype=GRB.INTEGER, name="milkshakes")

# Set objective function
model.setObjective(3.16 * apples + 3.02 * cantaloupes + 9.82 * blueberry_pies + 7.32 * apple_pies + 8.48 * ravioli + 8.96 * milkshakes, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * apples + 8 * ravioli >= 21, "c1")
model.addConstr(14 * cantaloupes + 8 * ravioli >= 28, "c2")
model.addConstr(3 * apples + 8 * blueberry_pies >= 15, "c3")
model.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 15, "c4")
model.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 15, "c5")
model.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 15, "c6")
model.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 22, "c7")
model.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 22, "c8")
model.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 22, "c9")
model.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 28, "c10")
model.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 28, "c11")
model.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 28, "c12")

model.addConstr(1 * apple_pies + 2 * milkshakes >= 16, "c13")
model.addConstr(9 * ravioli + 2 * milkshakes >= 18, "c14")
model.addConstr(1 * cantaloupes + 2 * milkshakes >= 18, "c15")
model.addConstr(1 * cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 18, "c16")
model.addConstr(4 * blueberry_pies + 1 * apple_pies + 9 * ravioli >= 18, "c17")
model.addConstr(1 * apples + 4 * blueberry_pies + 2 * milkshakes >= 18, "c18")
model.addConstr(1 * apples + 1 * apple_pies + 9 * ravioli >= 18, "c19")
model.addConstr(1 * cantaloupes + 9 * ravioli + 2 * milkshakes >= 18, "c20")

model.addConstr(1 * cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 19, "c21")
model.addConstr(4 * blueberry_pies + 1 * apple_pies + 9 * ravioli >= 19, "c22")
model.addConstr(1 * apples + 4 * blueberry_pies + 2 * milkshakes >= 19, "c23")
model.addConstr(1 * apples + 1 * apple_pies + 9 * ravioli >= 19, "c24")
model.addConstr(1 * cantaloupes + 9 * ravioli + 2 * milkshakes >= 19, "c25")

model.addConstr(1 * cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 21, "c26")
model.addConstr(4 * blueberry_pies + 1 * apple_pies + 9 * ravioli >= 21, "c27")
model.addConstr(1 * apples + 4 * blueberry_pies + 2 * milkshakes >= 21, "c28")
model.addConstr(1 * apples + 1 * apple_pies + 9 * ravioli >= 21, "c29")
model.addConstr(1 * cantaloupes + 9 * ravioli + 2 * milkshakes >= 21, "c30")


model.addConstr(1 * cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 18, "c31") # Repeated constraint
model.addConstr(4 * blueberry_pies + 1 * apple_pies + 9 * ravioli >= 18, "c32") # Repeated constraint
model.addConstr(1 * apples + 4 * blueberry_pies + 2 * milkshakes >= 18, "c33") # Repeated constraint
model.addConstr(1 * apples + 1 * apple_pies + 9 * ravioli >= 18, "c34") # Repeated constraint
model.addConstr(1 * cantaloupes + 9 * ravioli + 2 * milkshakes >= 18, "c35") # Repeated constraint

model.addConstr(1 * cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 20, "c36")
model.addConstr(4 * blueberry_pies + 1 * apple_pies + 9 * ravioli >= 20, "c37")
model.addConstr(1 * apples + 4 * blueberry_pies + 2 * milkshakes >= 20, "c38")
model.addConstr(1 * apples + 1 * apple_pies + 9 * ravioli >= 20, "c39")
model.addConstr(1 * cantaloupes + 9 * ravioli + 2 * milkshakes >= 20, "c40")


model.addConstr(8 * blueberry_pies + 7 * milkshakes <= 33, "c41")
model.addConstr(8 * ravioli + 7 * milkshakes <= 136, "c42")
model.addConstr(14 * cantaloupes + 8 * ravioli <= 92, "c43")
model.addConstr(14 * cantaloupes + 3 * apple_pies <= 159, "c44")
model.addConstr(8 * blueberry_pies + 8 * ravioli <= 114, "c45")

model.addConstr(3 * apples + 14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies + 8 * ravioli + 7 * milkshakes <= 114, "c46")

model.addConstr(4 * blueberry_pies + 1 * apple_pies <= 96, "c47")
model.addConstr(9 * ravioli + 2 * milkshakes <= 127, "c48")
model.addConstr(1 * apple_pies + 2 * milkshakes <= 30, "c49")
model.addConstr(1 * cantaloupes + 2 * milkshakes <= 72, "c50")
model.addConstr(1 * apples + 9 * ravioli <= 126, "c51")
model.addConstr(1 * apples + 1 * cantaloupes <= 137, "c52")
model.addConstr(1 * cantaloupes + 1 * apple_pies <= 167, "c53")
model.addConstr(4 * blueberry_pies + 2 * milkshakes <= 161, "c54")
model.addConstr(1 * cantaloupes + 9 * ravioli <= 132, "c55")
model.addConstr(1 * cantaloupes + 4 * blueberry_pies + 1 * apple_pies <= 62, "c56")
model.addConstr(1 * apples + 1 * cantaloupes + 4 * blueberry_pies <= 90, "c57")
model.addConstr(1 * cantaloupes + 4 * blueberry_pies + 9 * ravioli <= 157, "c58")
model.addConstr(1 * apples + 1 * cantaloupes + 4 * blueberry_pies + 1 * apple_pies + 9 * ravioli + 2 * milkshakes <= 157, "c59")


# Add resource constraints from the provided dictionary
resource_constraints = {
    'r0': {'description': 'tastiness rating', 'upper_bound': 182, 'x0': 3, 'x1': 14, 'x2': 8, 'x3': 3, 'x4': 8, 'x5': 7},
    'r1': {'description': 'grams of fat', 'upper_bound': 179, 'x0': 1, 'x1': 1, 'x2': 4, 'x3': 1, 'x4': 9, 'x5': 2}
}

for resource, data in resource_constraints.items():
    model.addConstr(
        data['x0'] * apples + data['x1'] * cantaloupes + data['x2'] * blueberry_pies + data['x3'] * apple_pies + data['x4'] * ravioli + data['x5'] * milkshakes <= data['upper_bound'],
        f"{resource}_constraint"
    )


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

