
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
apples = m.addVar(name="apples", vtype=gp.GRB.INTEGER)
cantaloupes = m.addVar(name="cantaloupes")
blueberry_pies = m.addVar(name="blueberry_pies")
apple_pies = m.addVar(name="apple_pies")
ravioli = m.addVar(name="ravioli", vtype=gp.GRB.INTEGER)
milkshakes = m.addVar(name="milkshakes", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(3.16 * apples + 3.02 * cantaloupes + 9.82 * blueberry_pies + 7.32 * apple_pies + 8.48 * ravioli + 8.96 * milkshakes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * apples + 8 * ravioli >= 21)
m.addConstr(14 * cantaloupes + 8 * ravioli >= 28)
m.addConstr(3 * apples + 8 * blueberry_pies >= 15)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 15)
m.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 15)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 15)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 22)
m.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 22)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 22)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 28)
m.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 28)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 28)
m.addConstr(apple_pies + 2 * milkshakes >= 16)
m.addConstr(9 * ravioli + 2 * milkshakes >= 18)
m.addConstr(cantaloupes + 2 * milkshakes >= 18)
m.addConstr(cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 18)
m.addConstr(4 * blueberry_pies + apple_pies + 9 * ravioli >= 18)
m.addConstr(apples + 4 * blueberry_pies + 2 * milkshakes >= 18)
m.addConstr(apples + apple_pies + 9 * ravioli >= 18)
m.addConstr(cantaloupes + 9 * ravioli + 2 * milkshakes >= 18)
m.addConstr(cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 19)
m.addConstr(4 * blueberry_pies + apple_pies + 9 * ravioli >= 19)
m.addConstr(apples + 4 * blueberry_pies + 2 * milkshakes >= 19)
m.addConstr(apples + apple_pies + 9 * ravioli >= 19)
m.addConstr(cantaloupes + 9 * ravioli + 2 * milkshakes >= 19)
m.addConstr(cantaloupes + 4 * blueberry_pies + 9 * ravioli >= 21)
m.addConstr(4 * blueberry_pies + apple_pies + 9 * ravioli >= 21)
m.addConstr(apples + 4 * blueberry_pies + 2 * milkshakes >= 21)
m.addConstr(apples + apple_pies + 9 * ravioli >= 21)
m.addConstr(cantaloupes + 9 * ravioli + 2 * milkshakes >= 21)
m.addConstr(8 * blueberry_pies + 7 * milkshakes <= 33)
m.addConstr(8 * ravioli + 7 * milkshakes <= 136)
m.addConstr(14 * cantaloupes + 8 * ravioli <= 92)
m.addConstr(14 * cantaloupes + 3 * apple_pies <= 159)
m.addConstr(8 * blueberry_pies + 8 * ravioli <= 114)
m.addConstr(3 * apples + 14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies + 8 * ravioli + 7 * milkshakes <= 114)
m.addConstr(4 * blueberry_pies + apple_pies <= 96)
m.addConstr(9 * ravioli + 2 * milkshakes <= 127)
m.addConstr(apple_pies + 2 * milkshakes <= 30)
m.addConstr(cantaloupes + 2 * milkshakes <= 72)
m.addConstr(apples + 9 * ravioli <= 126)
m.addConstr(apples + cantaloupes <= 137)
m.addConstr(cantaloupes + 3 * apple_pies <= 167)
m.addConstr(4 * blueberry_pies + 2 * milkshakes <= 161)
m.addConstr(cantaloupes + 9 * ravioli <= 132)
m.addConstr(cantaloupes + 4 * blueberry_pies + 3 * apple_pies <= 62)
m.addConstr(apples + cantaloupes + 4 * blueberry_pies <= 90)
m.addConstr(cantaloupes + 4 * blueberry_pies + 9 * ravioli <= 157)
m.addConstr(apples + cantaloupes + 4 * blueberry_pies + apple_pies + 9 * ravioli + 2 * milkshakes <= 157)

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Apples: {apples.varValue}")
    print(f"Cantaloupes: {cantaloupes.varValue}")
    print(f"Blueberry pies: {blueberry_pies.varValue}")
    print(f"Apple pies: {apple_pies.varValue}")
    print(f"Ravioli: {ravioli.varValue}")
    print(f"Milkshakes: {milkshakes.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
