
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")

# Set objective function
m.setObjective(2.69 * oranges + 1.69 * milkshakes + 1.85 * pickles, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * oranges + 10 * pickles >= 33, "fat_constraint1")
m.addConstr(2 * oranges + 9 * milkshakes >= 36, "fat_constraint2")
m.addConstr(2 * oranges + 9 * milkshakes + 10 * pickles >= 36, "fat_constraint3")
m.addConstr(9 * milkshakes + 10 * pickles <= 91, "fat_constraint4")


m.addConstr(11 * oranges + 13 * pickles >= 31, "carb_constraint1")
m.addConstr(11 * oranges + 16 * milkshakes >= 25, "carb_constraint2")
m.addConstr(11 * oranges + 16 * milkshakes + 13 * pickles >= 25, "carb_constraint3")
m.addConstr(16 * milkshakes + 13 * pickles <= 97, "carb_constraint4")

m.addConstr(2 * oranges <= 127, "fat_upper_bound") # grams of fat from oranges must be less than total fat allowed
m.addConstr(11 * oranges <= 129, "carb_upper_bound") # grams of carbs from oranges must be less than total carbs allowed

m.addConstr(-8 * oranges + 4 * milkshakes >= 0, "constraint4")
m.addConstr(2 * milkshakes - 9 * pickles >= 0, "constraint5")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('oranges:', oranges.x)
    print('milkshakes:', milkshakes.x)
    print('pickles:', pickles.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

