
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
oranges = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
milkshakes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milkshakes")
pickles = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")

# Objective function
m.setObjective(2.69 * oranges + 1.69 * milkshakes + 1.85 * pickles, GRB.MINIMIZE)

# Constraints
# Minimum fat intake constraints
m.addConstr(2*oranges + 10*pickles >= 33, name="min_fat_oranges_pickles")
m.addConstr(2*oranges + 9*milkshakes >= 36, name="min_fat_oranges_milkshakes")
m.addConstr(2*oranges + 9*milkshakes + 10*pickles >= 36, name="min_fat_all")

# Minimum carbohydrate intake constraints
m.addConstr(11*oranges + 13*pickles >= 31, name="min_carb_oranges_pickles")
m.addConstr(11*oranges + 16*milkshakes >= 25, name="min_carb_oranges_milkshakes")
m.addConstr(11*oranges + 16*milkshakes + 13*pickles >= 25, name="min_carb_all")

# Linear inequality constraints
m.addConstr(-8*oranges + 4*milkshakes >= 0, name="linear_ineq1")
m.addConstr(2*milkshakes - 9*pickles >= 0, name="linear_ineq2")

# Maximum fat and carbohydrate intake from milkshakes and pickles
m.addConstr(9*milkshakes + 10*pickles <= 91, name="max_fat_milkshakes_pickles")
m.addConstr(16*milkshakes + 13*pickles <= 97, name="max_carb_milkshakes_pickles")

# Upper bounds for fat and carbohydrate content (as given in the problem description)
m.addConstr(2*oranges + 9*milkshakes + 10*pickles <= 127, name="max_fat_total")
m.addConstr(11*oranges + 16*milkshakes + 13*pickles <= 129, name="max_carb_total")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Oranges: {oranges.x}")
    print(f"Milkshakes: {milkshakes.x}")
    print(f"Pickles: {pickles.x}")
else:
    print("No optimal solution found.")
