
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
coffee = model.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")
paperclips = model.addVar(vtype=GRB.INTEGER, name="paper_clips")

# Set objective function
model.setObjective(4.13 * coffee + 4.5 * paperclips, GRB.MINIMIZE)

# Add constraints
model.addConstr(10 * coffee + 8 * paperclips >= 32, "usefulness_lower")
model.addConstr(7 * coffee + 17 * paperclips >= 34, "sustainability_lower")
model.addConstr(13 * coffee + 11 * paperclips >= 25, "satisfaction_lower")
model.addConstr(8 * coffee - 3 * paperclips >= 0, "custom_constraint")
model.addConstr(10 * coffee + 8 * paperclips <= 82, "usefulness_upper")
model.addConstr(7 * coffee + 17 * paperclips <= 94, "sustainability_upper")
model.addConstr(13 * coffee + 11 * paperclips <= 25, "satisfaction_upper")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Cans of coffee: {coffee.x}")
    print(f"Paper clips: {paperclips.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

