
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Define variables
cans_of_coffee = model.addVar(name="cans_of_coffee", vtype=gp.GRB.INTEGER)
paper_clips = model.addVar(name="paper_clips", vtype=gp.GRB.INTEGER)

# Objective function
model.setObjective(4.13 * cans_of_coffee + 4.5 * paper_clips, gp.GRB.MINIMIZE)

# Usefulness rating constraint: 10*cans_of_coffee + 8*paper_clips >= 32
model.addConstr(10 * cans_of_coffee + 8 * paper_clips >= 32, name="usefulness_rating_min")
model.addConstr(10 * cans_of_coffee + 8 * paper_clips <= 122, name="usefulness_rating_max")

# Sustainability score constraint: 7*cans_of_coffee + 17*paper_clips >= 34
model.addConstr(7 * cans_of_coffee + 17 * paper_clips >= 34, name="sustainability_score_min")
model.addConstr(7 * cans_of_coffee + 17 * paper_clips <= 94, name="sustainability_score_max")

# Employee satisfaction impact constraint: 13*cans_of_coffee + 11*paper_clips >= 25
model.addConstr(13 * cans_of_coffee + 11 * paper_clips >= 25, name="employee_satisfaction_min")
model.addConstr(13 * cans_of_coffee + 11 * paper_clips <= 50, name="employee_satisfaction_max")

# Linear constraint: 8*cans_of_coffee - 3*paper_clips >= 0
model.addConstr(8 * cans_of_coffee - 3 * paper_clips >= 0, name="linear_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Cans of Coffee: {cans_of_coffee.varValue}")
    print(f"Paper Clips: {paper_clips.varValue}")
    print(f"Objective Value: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
