
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
magnesium = model.addVar(vtype=GRB.INTEGER, name="magnesium")  # Integer amount
carbohydrates = model.addVar(vtype=GRB.CONTINUOUS, name="carbohydrates")

# Set objective function
model.setObjective(7.49 * magnesium**2 + 1.91 * carbohydrates**2 + 1.27 * carbohydrates, GRB.MAXIMIZE)

# Add constraints
model.addConstr(8 * magnesium**2 + 2 * carbohydrates**2 >= 26, "immune_support_lower")
model.addConstr(20 * magnesium + 5 * carbohydrates >= 38, "cognitive_performance_lower")
model.addConstr(magnesium + 7 * carbohydrates >= 9, "muscle_growth_lower")
model.addConstr(16 * magnesium + 18 * carbohydrates >= 32, "energy_stability_lower")
model.addConstr(-10 * magnesium + 9 * carbohydrates >= 0, "custom_constraint")
model.addConstr(8 * magnesium + 2 * carbohydrates <= 69, "immune_support_upper")
model.addConstr(20 * magnesium**2 + 5 * carbohydrates**2 <= 122, "cognitive_performance_upper")
model.addConstr(magnesium + 7 * carbohydrates <= 44, "muscle_growth_upper")
model.addConstr(16 * magnesium**2 + 18 * carbohydrates**2 <= 59, "energy_stability_upper")


# Resource constraints (implicit in the problem description)
model.addConstr(8 * magnesium <= 72, "r0_magnesium")
model.addConstr(20 * magnesium <= 136, "r1_magnesium")
model.addConstr(magnesium <= 50, "r2_magnesium")
model.addConstr(16 * magnesium <= 119, "r3_magnesium")
model.addConstr(2 * carbohydrates <= 72, "r0_carbohydrates")
model.addConstr(5 * carbohydrates <= 136, "r1_carbohydrates")
model.addConstr(7 * carbohydrates <= 50, "r2_carbohydrates")
model.addConstr(18 * carbohydrates <= 119, "r3_carbohydrates")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Magnesium: {magnesium.x}")
    print(f"Carbohydrates: {carbohydrates.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

