
import gurobi as gp

# Create a new model
m = gp.Model()

# Define variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams_of_magnesium")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="grams_of_carbohydrates")

# Objective function
m.setObjective(7.49 * x0**2 + 1.91 * x1**2 + 1.27 * x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(8 * x0 == 8, name="immune_support_index_magnesium")
m.addConstr(20 * x0 == 20, name="cognitive_performance_index_magnesium")
m.addConstr(x0 == 1, name="muscle_growth_index_magnesium")
m.addConstr(16 * x0 == 16, name="energy_stability_index_magnesium")
m.addConstr(2 * x1 == 2, name="immune_support_index_carbohydrates")
m.addConstr(5 * x1 == 5, name="cognitive_performance_index_carbohydrates")
m.addConstr(7 * x1 == 7, name="muscle_growth_index_carbohydrates")
m.addConstr(18 * x1 == 18, name="energy_stability_index_carbohydrates")
m.addConstr(64 * x0**2 + 4 * x1**2 >= 26, name="combined_immune_support_index")
m.addConstr(20 * x0 + 5 * x1 >= 38, name="combined_cognitive_performance_index")
m.addConstr(x0 + 7 * x1 >= 9, name="combined_muscle_growth_index")
m.addConstr(16 * x0 + 18 * x1 >= 32, name="combined_energy_stability_index")
m.addConstr(-10 * x0 + 9 * x1 >= 0, name="linear_constraint")
m.addConstr(8 * x0 + 2 * x1 <= 69, name="combined_immune_support_index_upper_bound")
m.addConstr(20 * x0 + 5 * x1 <= 122, name="combined_cognitive_performance_index_upper_bound")
m.addConstr(x0 + 7 * x1 <= 44, name="combined_muscle_growth_index_upper_bound")
m.addConstr(256 * x0**2 + 324 * x1**2 <= 3481, name="combined_energy_stability_index_upper_bound")

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of magnesium: ", x0.varValue)
    print("Grams of carbohydrates: ", x1.varValue)
    print("Objective: ", m.objVal)
else:
    print("No optimal solution found.")
