
import gurobipy as gp

# Create a new model
m = gp.Model("Supplement_Optimization")

# Create variables
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
calcium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="calcium")
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")

# Set objective function
m.setObjective(2 * magnesium + vitamin_b12 + 6 * calcium + 6 * vitamin_b1, gp.GRB.MINIMIZE)

# Add constraints based on resource/attribute data
resource_data = {
    'r0': {'description': 'immune support index', 'upper_bound': 153, 'x0': 7, 'x1': 10, 'x2': 14, 'x3': 3},
    'r1': {'description': 'cardiovascular support index', 'upper_bound': 266, 'x0': 1, 'x1': 6, 'x2': 5, 'x3': 11},
    'r2': {'description': 'energy stability index', 'upper_bound': 186, 'x0': 2, 'x1': 10, 'x2': 4, 'x3': 14},
    'r3': {'description': 'kidney support index', 'upper_bound': 145, 'x0': 8, 'x1': 13, 'x2': 2, 'x3': 2}
}

for resource, data in resource_data.items():
    m.addConstr(data['x0'] * magnesium + data['x1'] * vitamin_b12 + data['x2'] * calcium + data['x3'] * vitamin_b1 <= data['upper_bound'], name=f"{data['description']}_upper_bound")


# Add other constraints from the problem description
m.addConstr(7 * magnesium + 10 * vitamin_b12 >= 21, "immune_1")
m.addConstr(7 * magnesium + 3 * vitamin_b1 >= 21, "immune_2")
m.addConstr(10 * vitamin_b12 + 3 * vitamin_b1 >= 31, "immune_3")
m.addConstr(7 * magnesium + 14 * calcium + 3 * vitamin_b1 >= 23, "immune_4")
m.addConstr(7 * magnesium + 10 * vitamin_b12 + 14 * calcium >= 23, "immune_5")
m.addConstr(7 * magnesium + 14 * calcium + 3 * vitamin_b1 >= 19, "immune_6")
m.addConstr(7 * magnesium + 10 * vitamin_b12 + 14 * calcium >= 19, "immune_7")
m.addConstr(7 * magnesium + 10 * vitamin_b12 + 14 * calcium + 3 * vitamin_b1 >= 19, "immune_8")

m.addConstr(magnesium + 5 * calcium >= 37, "cardio_1")
m.addConstr(6 * vitamin_b12 + 11 * vitamin_b1 >= 64, "cardio_2")
m.addConstr(magnesium + 6 * vitamin_b12 >= 22, "cardio_3")
m.addConstr(6 * vitamin_b12 + 5 * calcium >= 61, "cardio_4")
m.addConstr(magnesium + 11 * vitamin_b1 >= 33, "cardio_5")
m.addConstr(5 * calcium + 11 * vitamin_b1 >= 31, "cardio_6")
m.addConstr(magnesium + 6 * vitamin_b12 + 11 * vitamin_b1 >= 62, "cardio_7")
m.addConstr(magnesium + 6 * vitamin_b12 + 5 * calcium >= 62, "cardio_8")
m.addConstr(6 * vitamin_b12 + 5 * calcium + 11 * vitamin_b1 >= 62, "cardio_9")
m.addConstr(magnesium + 6 * vitamin_b12 + 11 * vitamin_b1 >= 52, "cardio_10")
m.addConstr(magnesium + 6 * vitamin_b12 + 5 * calcium >= 52, "cardio_11")
m.addConstr(6 * vitamin_b12 + 5 * calcium + 11 * vitamin_b1 >= 52, "cardio_12")
m.addConstr(magnesium + 6 * vitamin_b12 + 11 * vitamin_b1 >= 66, "cardio_13")
m.addConstr(magnesium + 6 * vitamin_b12 + 5 * calcium >= 66, "cardio_14")
m.addConstr(6 * vitamin_b12 + 5 * calcium + 11 * vitamin_b1 >= 66, "cardio_15")
m.addConstr(magnesium + 6 * vitamin_b12 + 5 * calcium + 11 * vitamin_b1 >= 66, "cardio_16")


m.addConstr(4 * calcium + 14 * vitamin_b1 >= 41, "energy_1")
m.addConstr(2 * magnesium + 10 * vitamin_b12 >= 20, "energy_2")
m.addConstr(10 * vitamin_b12 + 14 * vitamin_b1 >= 21, "energy_3")
m.addConstr(2 * magnesium + 4 * calcium + 14 * vitamin_b1 >= 34, "energy_4")
m.addConstr(2 * magnesium + 10 * vitamin_b12 + 14 * vitamin_b1 >= 34, "energy_5")
m.addConstr(2 * magnesium + 4 * calcium + 14 * vitamin_b1 >= 38, "energy_6")
m.addConstr(2 * magnesium + 10 * vitamin_b12 + 14 * vitamin_b1 >= 38, "energy_7")
m.addConstr(2 * magnesium + 10 * vitamin_b12 + 4 * calcium + 14 * vitamin_b1 >= 38, "energy_8")

m.addConstr(2 * calcium + 2 * vitamin_b1 >= 21, "kidney_1")
m.addConstr(13 * vitamin_b12 + 2 * vitamin_b1 >= 26, "kidney_2")
m.addConstr(13 * vitamin_b12 + 2 * calcium >= 14, "kidney_3")
m.addConstr(8 * magnesium + 2 * calcium + 2 * vitamin_b1 >= 31, "kidney_4")
m.addConstr(8 * magnesium + 13 * vitamin_b12 + 2 * calcium + 2 * vitamin_b1 >= 31, "kidney_5")


m.addConstr(magnesium - 10 * vitamin_b12 >= 0, "constraint_1")
m.addConstr(7 * magnesium + 3 * vitamin_b1 <= 99, "immune_ub_1")
m.addConstr(10 * vitamin_b12 + 14 * calcium <= 80, "immune_ub_2")
m.addConstr(magnesium + 11 * vitamin_b1 <= 72, "cardio_ub_1")
m.addConstr(magnesium + 6 * vitamin_b12 <= 175, "cardio_ub_2")
m.addConstr(6 * vitamin_b12 + 5 * calcium <= 150, "cardio_ub_3")
m.addConstr(10 * vitamin_b12 + 14 * vitamin_b1 <= 164, "energy_ub_1")
m.addConstr(4 * calcium + 14 * vitamin_b1 <= 86, "energy_ub_2")
m.addConstr(2 * magnesium + 14 * vitamin_b1 <= 130, "energy_ub_3")
m.addConstr(2 * magnesium + 10 * vitamin_b12 <= 116, "energy_ub_4")
m.addConstr(2 * magnesium + 10 * vitamin_b12 + 4 * calcium <= 185, "energy_ub_5")
m.addConstr(8 * magnesium + 2 * vitamin_b1 <= 73, "kidney_ub_1")
m.addConstr(8 * magnesium + 13 * vitamin_b12 <= 40, "kidney_ub_2")
m.addConstr(13 * vitamin_b12 + 2 * vitamin_b1 <= 111, "kidney_ub_3")
m.addConstr(8 * magnesium + 2 * calcium <= 102, "kidney_ub_4")
m.addConstr(8 * magnesium + 13 * vitamin_b12 + 2 * vitamin_b1 <= 82, "kidney_ub_5")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")
