
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams of magnesium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="milligrams of vitamin B12", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams of calcium", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.CONTINUOUS)
    x3 = model.addVar(name="milligrams of vitamin B1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(2*x0 + x1 + 6*x2 + 6*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    # Immune support index
    model.addConstr(7*x0 + 10*x1 + 14*x2 + 3*x3 >= 21)
    model.addConstr(7*x0 + 3*x3 >= 21)
    model.addConstr(10*x1 + 3*x3 >= 31)
    model.addConstr(7*x0 + 14*x2 + 3*x3 >= 23)
    model.addConstr(7*x0 + 10*x1 + 14*x2 >= 23)
    model.addConstr(7*x0 + 14*x2 + 3*x3 >= 19)
    model.addConstr(7*x0 + 10*x1 + 14*x2 >= 19)
    model.addConstr(7*x0 + 10*x1 + 14*x2 + 3*x3 >= 19)

    # Cardiovascular support index
    model.addConstr(x0 + 5*x2 >= 37)
    model.addConstr(6*x1 + 11*x3 >= 64)
    model.addConstr(x0 + 6*x1 >= 22)
    model.addConstr(6*x1 + 5*x2 >= 61)
    model.addConstr(x0 + 11*x3 >= 33)
    model.addConstr(5*x2 + 11*x3 >= 31)
    model.addConstr(x0 + 6*x1 + 11*x3 >= 62)
    model.addConstr(x0 + 6*x1 + 5*x2 >= 62)
    model.addConstr(6*x1 + 5*x2 + 11*x3 >= 62)
    model.addConstr(x0 + 6*x1 + 11*x3 >= 52)
    model.addConstr(x0 + 6*x1 + 5*x2 >= 52)
    model.addConstr(6*x1 + 5*x2 + 11*x3 >= 52)
    model.addConstr(x0 + 6*x1 + 11*x3 >= 66)
    model.addConstr(x0 + 6*x1 + 5*x2 >= 66)
    model.addConstr(6*x1 + 5*x2 + 11*x3 >= 66)
    model.addConstr(x0 + 6*x1 + 5*x2 + 11*x3 >= 66)

    # Energy stability index
    model.addConstr(4*x2 + 14*x3 >= 41)
    model.addConstr(2*x0 + 10*x1 >= 20)
    model.addConstr(10*x1 + 14*x3 >= 21)
    model.addConstr(2*x0 + 4*x2 + 14*x3 >= 34)
    model.addConstr(2*x0 + 10*x1 + 14*x3 >= 34)
    model.addConstr(2*x0 + 4*x2 + 14*x3 >= 38)
    model.addConstr(2*x0 + 10*x1 + 14*x3 >= 38)
    model.addConstr(2*x0 + 10*x1 + 4*x2 + 14*x3 >= 38)
    model.addConstr(4*x2 + 14*x3 <= 86)
    model.addConstr(2*x0 + 14*x3 <= 130)
    model.addConstr(2*x0 + 10*x1 <= 116)
    model.addConstr(2*x0 + 10*x1 + 4*x2 <= 185)

    # Kidney support index
    model.addConstr(2*x2 + 2*x3 >= 21)
    model.addConstr(13*x1 + 2*x3 >= 26)
    model.addConstr(13*x1 + 2*x2 >= 14)
    model.addConstr(8*x0 + 2*x2 + 2*x3 >= 31)
    model.addConstr(8*x0 + 13*x1 + 2*x2 + 2*x3 >= 31)
    model.addConstr(x0 - 10*x1 >= 0)
    model.addConstr(8*x0 + 2*x3 <= 73)
    model.addConstr(8*x0 + 13*x1 <= 40)
    model.addConstr(13*x1 + 2*x3 <= 111)
    model.addConstr(8*x0 + 2*x2 <= 102)
    model.addConstr(8*x0 + 13*x1 + 2*x3 <= 82)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of magnesium: {x0.varValue}")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Milligrams of calcium: {x2.varValue}")
        print(f"Milligrams of vitamin B1: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
