
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_vitamin_B9", lb=0)
x1 = m.addVar(name="milligrams_of_vitamin_B1", lb=0)
x2 = m.addVar(name="milligrams_of_vitamin_K", lb=0)
x3 = m.addVar(name="milligrams_of_vitamin_B3", lb=0)

# Define the objective function
m.setObjective(8.52 * x0 + 6.24 * x1 + 3.36 * x2 + 9.23 * x3, gp.GRB.MINIMIZE)

# Add constraints
# Energy stability index constraints
m.addConstr(9 * x0 + 8 * x1 + 8 * x2 + 10 * x3 <= 94, name="energy_stability_index")
m.addConstr(8 * x1 + 8 * x0 + 8 * x2 + 10 * x3 >= 7, name="energy_stability_index_1")
m.addConstr(9 * x0 + 8 * x2 + 10 * x3 >= 18, name="energy_stability_index_2")
m.addConstr(8 * x2 + 10 * x3 >= 22, name="energy_stability_index_3")
m.addConstr(9 * x0 + 8 * x1 >= 10, name="energy_stability_index_4")
m.addConstr(9 * x0 + 10 * x3 >= 17, name="energy_stability_index_5")
m.addConstr(9 * x0 + 8 * x1 + 8 * x2 + 10 * x3 >= 17, name="energy_stability_index_6")

# Kidney support index constraints
m.addConstr(7 * x0 + 7 * x1 + 9 * x2 + 8 * x3 <= 57, name="kidney_support_index")
m.addConstr(7 * x0 + 9 * x2 + 8 * x3 >= 11, name="kidney_support_index_1")
m.addConstr(7 * x0 + 9 * x2 >= 7, name="kidney_support_index_2")
m.addConstr(7 * x0 + 7 * x1 + 9 * x2 + 8 * x3 >= 7, name="kidney_support_index_3")

# Muscle growth index constraints
m.addConstr(3 * x0 + 7 * x1 + x2 + 2 * x3 <= 49, name="muscle_growth_index")
m.addConstr(3 * x0 + x2 >= 6, name="muscle_growth_index_1")
m.addConstr(7 * x1 + x2 >= 10, name="muscle_growth_index_2")
m.addConstr(x2 + 2 * x3 >= 6, name="muscle_growth_index_3")
m.addConstr(7 * x1 + 2 * x3 >= 7, name="muscle_growth_index_4")
m.addConstr(3 * x0 + 7 * x1 >= 4, name="muscle_growth_index_5")
m.addConstr(3 * x0 + 2 * x3 >= 11, name="muscle_growth_index_6")
m.addConstr(3 * x0 + 7 * x1 + x2 + 2 * x3 >= 11, name="muscle_growth_index_7")

# Linear constraints
m.addConstr(-6 * x1 + 10 * x3 >= 0, name="linear_constraint")
m.addConstr(-5 * x0 + 9 * x3 >= 0, name="linear_constraint_1")
m.addConstr(7 * x1 - 7 * x2 >= 0, name="linear_constraint_2")

# Upper bound constraints
m.addConstr(8 * x1 + 10 * x3 <= 54, name="upper_bound_constraint")
m.addConstr(9 * x0 + 8 * x2 <= 64, name="upper_bound_constraint_1")
m.addConstr(8 * x2 + 10 * x3 <= 55, name="upper_bound_constraint_2")
m.addConstr(9 * x0 + 10 * x3 <= 76, name="upper_bound_constraint_3")
m.addConstr(7 * x0 + 7 * x1 <= 34, name="upper_bound_constraint_4")
m.addConstr(7 * x0 + 9 * x2 <= 41, name="upper_bound_constraint_5")
m.addConstr(7 * x1 + 9 * x2 <= 17, name="upper_bound_constraint_6")
m.addConstr(9 * x2 + 8 * x3 <= 35, name="upper_bound_constraint_7")
m.addConstr(3 * x0 + 2 * x3 <= 24, name="upper_bound_constraint_8")
m.addConstr(7 * x1 + 2 * x3 <= 43, name="upper_bound_constraint_9")
m.addConstr(3 * x0 + 7 * x1 <= 27, name="upper_bound_constraint_10")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B9: {x0.varValue}")
    print(f"Milligrams of vitamin B1: {x1.varValue}")
    print(f"Milligrams of vitamin K: {x2.varValue}")
    print(f"Milligrams of vitamin B3: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
