
import gurobipy as gp

# Create a new model
m = gp.Model("WorkOptimization")

# Create variables
laura_hours = m.addVar(vtype=gp.GRB.INTEGER, name="laura_hours")
dale_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dale_hours")
bobby_hours = m.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
peggy_hours = m.addVar(vtype=gp.GRB.INTEGER, name="peggy_hours")

# Set objective function
m.setObjective(5.85 * laura_hours + 6.48 * dale_hours + 9.25 * bobby_hours + 9.29 * peggy_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * laura_hours + 3 * dale_hours >= 65, "c0")
m.addConstr(9 * laura_hours + 5 * peggy_hours >= 29, "c1")
m.addConstr(5 * bobby_hours + 5 * peggy_hours >= 26, "c2")
m.addConstr(3 * dale_hours + 5 * bobby_hours >= 70, "c3")
m.addConstr(9 * laura_hours + 5 * bobby_hours >= 66, "c4")
m.addConstr(9 * laura_hours + 3 * dale_hours + 5 * bobby_hours + 5 * peggy_hours >= 66, "c5")
m.addConstr(1 * dale_hours + 6 * peggy_hours >= 38, "c6")
m.addConstr(9 * laura_hours + 5 * bobby_hours >= 28, "c7")
m.addConstr(9 * laura_hours + 1 * dale_hours >= 54, "c8")
m.addConstr(5 * bobby_hours + 6 * peggy_hours >= 66, "c9")
m.addConstr(9 * laura_hours + 1 * dale_hours + 6 * peggy_hours >= 72, "c10")
m.addConstr(9 * laura_hours + 5 * bobby_hours + 6 * peggy_hours >= 72, "c11")
m.addConstr(9 * laura_hours + 1 * dale_hours + 6 * peggy_hours >= 51, "c12")
m.addConstr(9 * laura_hours + 5 * bobby_hours + 6 * peggy_hours >= 51, "c13")
m.addConstr(9 * laura_hours + 1 * dale_hours + 5 * bobby_hours + 6 * peggy_hours >= 51, "c14")
m.addConstr(7 * dale_hours + 7 * peggy_hours >= 21, "c15")
m.addConstr(10 * laura_hours + 9 * bobby_hours >= 24, "c16")
m.addConstr(10 * laura_hours + 7 * dale_hours + 9 * bobby_hours + 7 * peggy_hours >= 24, "c17")
m.addConstr(4 * dale_hours + 5 * peggy_hours >= 17, "c18")
m.addConstr(5 * laura_hours + 4 * dale_hours >= 15, "c19")
m.addConstr(4 * dale_hours + 8 * bobby_hours >= 32, "c20")
m.addConstr(8 * bobby_hours + 5 * peggy_hours >= 30, "c21")
m.addConstr(5 * laura_hours + 4 * dale_hours + 8 * bobby_hours + 5 * peggy_hours >= 30, "c22")
m.addConstr(11 * dale_hours + 2 * peggy_hours >= 35, "c23")
m.addConstr(11 * dale_hours + 10 * bobby_hours >= 33, "c24")
m.addConstr(10 * bobby_hours + 2 * peggy_hours >= 66, "c25")
m.addConstr(6 * laura_hours + 2 * peggy_hours >= 80, "c26")
m.addConstr(6 * laura_hours + 11 * dale_hours + 10 * bobby_hours >= 75, "c27")
m.addConstr(6 * laura_hours + 11 * dale_hours + 10 * bobby_hours + 2 * peggy_hours >= 75, "c28")
m.addConstr(-10 * laura_hours + 8 * bobby_hours >= 0, "c29")
m.addConstr(-3 * dale_hours + 4 * peggy_hours >= 0, "c30")
m.addConstr(9 * laura_hours + 5 * bobby_hours <= 215, "c31")
m.addConstr(9 * laura_hours + 3 * dale_hours + 5 * bobby_hours <= 100, "c32")
m.addConstr(9 * laura_hours + 1 * dale_hours + 6 * peggy_hours <= 188, "c33")
m.addConstr(1 * dale_hours + 5 * bobby_hours + 6 * peggy_hours <= 206, "c34")
m.addConstr(10 * laura_hours + 9 * bobby_hours <= 80, "c35")
m.addConstr(10 * laura_hours + 7 * peggy_hours <= 63, "c36")
m.addConstr(7 * dale_hours + 7 * peggy_hours <= 75, "c37")
m.addConstr(10 * laura_hours + 7 * dale_hours <= 123, "c38")
m.addConstr(7 * dale_hours + 9 * bobby_hours + 7 * peggy_hours <= 33, "c39")
m.addConstr(10 * laura_hours + 7 * dale_hours + 9 * bobby_hours <= 107, "c40")
m.addConstr(10 * laura_hours + 9 * bobby_hours + 7 * peggy_hours <= 48, "c41")
m.addConstr(5 * laura_hours + 4 * dale_hours + 8 * bobby_hours <= 108, "c42")
m.addConstr(6 * laura_hours + 10 * bobby_hours <= 279, "c43")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Laura Hours:', laura_hours.x)
    print('Dale Hours:', dale_hours.x)
    print('Bobby Hours:', bobby_hours.x)
    print('Peggy Hours:', peggy_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
