
from gurobipy import Model, GRB

# Create a new model
m = Model("mobility_optimization")

# Create variables
logistics_companies = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
signal_platoons = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
transportation_companies = m.addVar(vtype=GRB.INTEGER, name="transportation_companies")

# Set objective function
m.setObjective(1 * logistics_companies + 9 * signal_platoons + 6 * transportation_companies, GRB.MINIMIZE)

# Add constraints
m.addConstr(4.57 * logistics_companies + 1.6 * signal_platoons >= 31, "mobility_constraint1")
m.addConstr(4.57 * logistics_companies + 3.13 * transportation_companies >= 23, "mobility_constraint2")
m.addConstr(4.57 * logistics_companies + 1.6 * signal_platoons + 3.13 * transportation_companies >= 55, "mobility_constraint3")
m.addConstr(5 * logistics_companies - 2 * signal_platoons >= 0, "constraint4")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('logistics_companies:', logistics_companies.x)
    print('signal_platoons:', signal_platoons.x)
    print('transportation_companies:', transportation_companies.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

