
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
L = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
S = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
T = m.addVar(vtype=GRB.INTEGER, name="transportation_companies")

# Objective function
m.setObjective(1*L + 9*S + 6*T, GRB.MINIMIZE)

# Constraints
m.addConstr(4.57*L + 1.6*S >= 31, name="mobility_rating_1")
m.addConstr(4.57*L + 3.13*T >= 23, name="mobility_rating_2")
m.addConstr(4.57*L + 1.6*S + 3.13*T >= 55, name="total_mobility_rating")
m.addConstr(5*L - 2*S >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Logistics Companies: {L.x}")
    print(f"Signal Platoons: {S.x}")
    print(f"Transportation Companies: {T.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
