
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
logistics_companies = m.addVar(name="logistics_companies", integer=True)
signal_platoons = m.addVar(name="signal_platoons", integer=True)
transportation_companies = m.addVar(name="transportation_companies", integer=True)

# Objective function: Minimize 1 * logistics_companies + 9 * signal_platoons + 6 * transportation_companies
m.setObjective(logistics_companies + 9 * signal_platoons + 6 * transportation_companies, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4.57 * logistics_companies <= 4.57, "mobility_rating_logistics")
m.addConstr(4.57 * logistics_companies >= 4.57, "mobility_rating_logistics_eq")
m.addConstr(4.57 * logistics_companies + 1.6 * signal_platoons >= 31, "mobility_rating_logistics_signal")
m.addConstr(4.57 * logistics_companies + 3.13 * transportation_companies >= 23, "mobility_rating_logistics_transportation")
m.addConstr(4.57 * logistics_companies + 1.6 * signal_platoons + 3.13 * transportation_companies >= 55, "mobility_rating_total")
m.addConstr(5 * logistics_companies - 2 * signal_platoons >= 0, "relationship_logistics_signal")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Logistics Companies: {logistics_companies.varValue}")
    print(f"Signal Platoons: {signal_platoons.varValue}")
    print(f"Transportation Companies: {transportation_companies.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
