
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables (assuming they are non-negative)
G = m.addVar(lb=0, name="George")
H = m.addVar(lb=0, name="Hank")
R = m.addVar(lb=0, name="Ringo")
P = m.addVar(lb=0, name="Peggy")
Pa = m.addVar(lb=0, name="Paul")
J = m.addVar(lb=0, name="John")
B = m.addVar(lb=0, name="Bill")

# Objective function: For demonstration, let's minimize the total hours worked
m.setObjective(G + H + R + P + Pa + J + B, GRB.MINIMIZE)

# Constraints: Let's add a few for illustration purposes
# Assuming coefficients are known and filled in appropriately

# Example constraint 1: Total computer competence rating from some workers
m.addConstr(10*G + 20*H + 15*R, GRB.LESS_EQUAL, 1000)  # Example max total rating

# Example constraint 2: Productivity rating constraint
m.addConstr(5*P + 8*Pa + 12*J, GRB.LESS_EQUAL, 2000)  # Example max productivity rating

# Example constraint 3: Work quality rating constraint
m.addConstr(20*R + 15*P + 10*B, GRB.GREATER_EQUAL, 500)  # Example min work quality rating

# Example constraint 4: Linear combination of hours worked by certain employees
m.addConstr(-4*P + 3*Pa, GRB.GREATER_EQUAL, 0)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
