
from gurobipy import *

# Create a new model
m = Model()

# Define the variables
hours_worked_by_George = m.addVar(name="hours_worked_by_George", lb=0)
hours_worked_by_Hank = m.addVar(name="hours_worked_by_Hank", lb=0)
hours_worked_by_Ringo = m.addVar(name="hours_worked_by_Ringo", lb=0)
hours_worked_by_Peggy = m.addVar(name="hours_worked_by_Peggy", lb=0)
hours_worked_by_Paul = m.addVar(name="hours_worked_by_Paul", lb=0)
hours_worked_by_John = m.addVar(name="hours_worked_by_John", lb=0)
hours_worked_by_Bill = m.addVar(name="hours_worked_by_Bill", lb=0)

# Objective function: Minimize 5 * hours_worked_by_George + 5 * hours_worked_by_Hank + 9 * hours_worked_by_Ringo + 2 * hours_worked_by_Peggy + 1 * hours_worked_by_Paul + 2 * hours_worked_by_John + 5 * hours_worked_by_Bill
m.setObjective(5 * hours_worked_by_George + 5 * hours_worked_by_Hank + 9 * hours_worked_by_Ringo + 2 * hours_worked_by_Peggy + 1 * hours_worked_by_Paul + 2 * hours_worked_by_John + 5 * hours_worked_by_Bill, GRB.MINIMIZE)

# Constraints
# Productivity ratings
m.addConstr(10 * hours_worked_by_George <= 334)
m.addConstr(13 * hours_worked_by_Hank <= 334)
m.addConstr(2 * hours_worked_by_Ringo <= 334)
m.addConstr(3 * hours_worked_by_Peggy <= 334)
m.addConstr(7 * hours_worked_by_Paul <= 334)
m.addConstr(5 * hours_worked_by_John <= 334)
m.addConstr(4 * hours_worked_by_Bill <= 334)

# Computer competence ratings
m.addConstr(19 * hours_worked_by_George <= 195)
m.addConstr(8 * hours_worked_by_Hank <= 195)
m.addConstr(3 * hours_worked_by_Ringo <= 195)
m.addConstr(12 * hours_worked_by_Peggy <= 195)
m.addConstr(7 * hours_worked_by_Paul <= 195)
m.addConstr(15 * hours_worked_by_John <= 195)
m.addConstr(5 * hours_worked_by_Bill <= 195)

# Work quality ratings
m.addConstr(6 * hours_worked_by_George <= 262)
m.addConstr(3 * hours_worked_by_Hank <= 262)
m.addConstr(1 * hours_worked_by_Ringo <= 262)
m.addConstr(3 * hours_worked_by_Peggy <= 262)
m.addConstr(13 * hours_worked_by_Paul <= 262)
m.addConstr(13 * hours_worked_by_John <= 262)
m.addConstr(12 * hours_worked_by_Bill <= 262)

# Additional constraints
m.addConstr(10 * hours_worked_by_George >= 10)
m.addConstr(19 * hours_worked_by_George >= 19)
m.addConstr(6 * hours_worked_by_George >= 6)
m.addConstr(13 * hours_worked_by_Hank >= 13)
m.addConstr(8 * hours_worked_by_Hank >= 8)
m.addConstr(3 * hours_worked_by_Hank >= 3)
m.addConstr(2 * hours_worked_by_Ringo >= 2)
m.addConstr(3 * hours_worked_by_Ringo >= 3)
m.addConstr(1 * hours_worked_by_Ringo >= 1)
m.addConstr(3 * hours_worked_by_Peggy >= 3)
m.addConstr(12 * hours_worked_by_Peggy >= 12)
m.addConstr(3 * hours_worked_by_Peggy >= 3)
m.addConstr(7 * hours_worked_by_Paul >= 7)
m.addConstr(7 * hours_worked_by_Paul >= 7)
m.addConstr(13 * hours_worked_by_Paul >= 13)
m.addConstr(5 * hours_worked_by_John >= 5)
m.addConstr(15 * hours_worked_by_John >= 15)
m.addConstr(13 * hours_worked_by_John >= 13)
m.addConstr(4 * hours_worked_by_Bill >= 4)
m.addConstr(5 * hours_worked_by_Bill >= 5)
m.addConstr(12 * hours_worked_by_Bill >= 12)

# Combined productivity ratings
m.addConstr(3 * hours_worked_by_Peggy + 5 * hours_worked_by_John >= 28)
m.addConstr(10 * hours_worked_by_George + 3 * hours_worked_by_Peggy >= 28)
m.addConstr(7 * hours_worked_by_Paul + 4 * hours_worked_by_Bill >= 39)
m.addConstr(13 * hours_worked_by_Hank + 4 * hours_worked_by_Bill >= 29)
m.addConstr(2 * hours_worked_by_Ringo + 3 * hours_worked_by_Peggy >= 36)
m.addConstr(10 * hours_worked_by_George + 2 * hours_worked_by_Ringo >= 41)
m.addConstr(2 * hours_worked_by_Ringo + 4 * hours_worked_by_Bill >= 20)
m.addConstr(3 * hours_worked_by_Peggy + 4 * hours_worked_by_Bill >= 25)
m.addConstr(10 * hours_worked_by_George + 13 * hours_worked_by_Hank + 2 * hours_worked_by_Ringo + 3 * hours_worked_by_Peggy + 7 * hours_worked_by_Paul + 5 * hours_worked_by_John + 4 * hours_worked_by_Bill >= 25)

# Combined computer competence ratings
m.addConstr(7 * hours_worked_by_Paul + 15 * hours_worked_by_John >= 17)
m.addConstr(8 * hours_worked_by_Hank + 5 * hours_worked_by_Bill >= 15)
m.addConstr(12 * hours_worked_by_Peggy + 7 * hours_worked_by_Paul >= 20)
m.addConstr(12 * hours_worked_by_Peggy + 15 * hours_worked_by_John >= 16)
m.addConstr(8 * hours_worked_by_Hank + 15 * hours_worked_by_John >= 11)
m.addConstr(19 * hours_worked_by_George + 7 * hours_worked_by_Paul >= 16)
m.addConstr(8 * hours_worked_by_Hank + 12 * hours_worked_by_Peggy >= 15)
m.addConstr(3 * hours_worked_by_Ringo + 15 * hours_worked_by_John >= 21)
m.addConstr(19 * hours_worked_by_George + 3 * hours_worked_by_Ringo >= 21)
m.addConstr(19 * hours_worked_by_George + 3 * hours_worked_by_Ringo + 15 * hours_worked_by_John >= 14)

# Work quality ratings
m.addConstr(3 * hours_worked_by_Peggy + 13 * hours_worked_by_Paul >= 27)
m.addConstr(3 * hours_worked_by_Peggy + 12 * hours_worked_by_Bill >= 26)
m.addConstr(13 * hours_worked_by_John + 12 * hours_worked_by_Bill >= 19)
m.addConstr(1 * hours_worked_by_Ringo + 13 * hours_worked_by_Paul >= 12)
m.addConstr(3 * hours_worked_by_Hank + 13 * hours_worked_by_John >= 22)
m.addConstr(3 * hours_worked_by_Hank + 3 * hours_worked_by_Peggy >= 33)
m.addConstr(1 * hours_worked_by_Ringo + 13 * hours_worked_by_John >= 26)
m.addConstr(6 * hours_worked_by_George + 3 * hours_worked_by_Hank >= 14)
m.addConstr(1 * hours_worked_by_Ringo + 12 * hours_worked_by_Bill >= 36)
m.addConstr(13 * hours_worked_by_Paul + 12 * hours_worked_by_Bill >= 33)
m.addConstr(6 * hours_worked_by_George + 1 * hours_worked_by_Ringo >= 18)
m.addConstr(3 * hours_worked_by_Hank + 13 * hours_worked_by_Paul >= 27)
m.addConstr(3 * hours_worked_by_Peggy + 13 * hours_worked_by_Paul + 13 * hours_worked_by_John >= 22)
m.addConstr(1 * hours_worked_by_Ringo + 13 * hours_worked_by_Paul + 13 * hours_worked_by_John >= 22)
m.addConstr(3 * hours_worked_by_Peggy + 13 * hours_worked_by_Paul + 13 * hours_worked_by_John >= 31)
m.addConstr(1 * hours_worked_by_Ringo + 13 * hours_worked_by_Paul + 13 * hours_worked_by_John >= 31)
m.addConstr(6 * hours_worked_by_George + 3 * hours_worked_by_Hank + 1 * hours_worked_by_Ringo + 3 * hours_worked_by_Peggy + 13 * hours_worked_by_Paul + 13 * hours_worked_by_John + 12 * hours_worked_by_Bill >= 31)

# Other constraints
m.addConstr(-4 * hours_worked_by_Peggy + 3 * hours_worked_by_Paul >= 0)
m.addConstr(9 * hours_worked_by_George - 1 * hours_worked_by_Bill >= 0)
m.addConstr(10 * hours_worked_by_George + 13 * hours_worked_by_Hank + 2 * hours_worked_by_Ringo <= 227)
m.addConstr(8 * hours_worked_by_Hank + 7 * hours_worked_by_Paul + 5 * hours_worked_by_Bill <= 81)
m.addConstr(10 * hours_worked_by_George + 3 * hours_worked_by_Peggy + 4 * hours_worked_by_Bill <= 190)
m.addConstr(10 * hours_worked_by_George + 13 * hours_worked_by_Hank + 3 * hours_worked_by_Peggy <= 115)
m.addConstr(3 * hours_worked_by_Peggy + 5 * hours_worked_by_John + 12 * hours_worked_by_Bill <= 54)
m.addConstr(8 * hours_worked_by_Hank + 3 * hours_worked_by_Peggy + 12 * hours_worked_by_Bill <= 275)
m.addConstr(10 * hours_worked_by_George + 2 * hours_worked_by_Ringo + 4 * hours_worked_by_Bill <= 190)
m.addConstr(10 * hours_worked_by_George + 13 * hours_worked_by_Hank + 7 * hours_worked_by_Paul <= 150)
m.addConstr(10 * hours_worked_by_George + 2 * hours_worked_by_Ringo + 3 * hours_worked_by_Peggy <= 192)
m.addConstr(13 * hours_worked_by_Hank + 1 * hours_worked_by_Ringo + 7 * hours_worked_by_Paul <= 205)
m.addConstr(10 * hours_worked_by_George + 2 * hours_worked_by_Ringo + 5 * hours_worked_by_John <= 78)
m.addConstr(10 * hours_worked_by_George + 2 * hours_worked_by_Ringo + 7 * hours_worked_by_Paul <= 307)
m.addConstr(10 * hours_worked_by_George + 7 * hours_worked_by_Paul + 5 * hours_worked_by_John <= 207)
m.addConstr(10 * hours_worked_by_George + 13 * hours_worked_by_Hank + 4 * hours_worked_by_Bill <= 55)
m.addConstr(13 * hours_worked_by_Hank + 1 * hours_worked_by_Ringo + 4 * hours_worked_by_Bill <= 249)
m.addConstr(10 * hours_worked_by_George + 7 * hours_worked_by_Paul + 4 * hours_worked_by_Bill <= 66)

# Solve the problem
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by George:", hours_worked_by_George.varValue)
    print("Hours worked by Hank:", hours_worked_by_Hank.varValue)
    print("Hours worked by Ringo:", hours_worked_by_Ringo.varValue)
    print("Hours worked by Peggy:", hours_worked_by_Peggy.varValue)
    print("Hours worked by Paul:", hours_worked_by_Paul.varValue)
    print("Hours worked by John:", hours_worked_by_John.varValue)
    print("Hours worked by Bill:", hours_worked_by_Bill.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
