
from gurobipy import Model, GRB

# Create a new model
model = Model("optimize_work_hours")

# Create variables
paul_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="paul_hours")
dale_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale_hours")

# Set objective function
model.setObjective(3 * paul_hours + 1 * dale_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(14 * paul_hours + 7 * dale_hours >= 77, "total_likelihood_min")
model.addConstr(14 * paul_hours + 7 * dale_hours <= 130, "total_likelihood_max")
model.addConstr(21 * paul_hours + 13 * dale_hours >= 39, "total_quality_min")
model.addConstr(21 * paul_hours + 13 * dale_hours <= 116, "total_quality_max")
model.addConstr(9 * paul_hours - 4 * dale_hours >= 0, "paul_dale_ratio")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal hours for Paul: {paul_hours.x}")
    print(f"Optimal hours for Dale: {dale_hours.x}")
    print(f"Optimal objective value: {model.objVal}")

