
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
P = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
D = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")

# Objective function: Maximize 3*P + D
m.setObjective(3*P + D, GRB.MAXIMIZE)

# Constraints
# Total combined likelihood to quit index is exactly 130 (interpreted from the problem statement)
m.addConstr(14*P + 7*D == 130, name="likelihood_to_quit_index")

# Total combined work quality rating is exactly 116 (interpreted from the problem statement)
m.addConstr(21*P + 13*D == 116, name="work_quality_rating")

# Additional constraint
m.addConstr(9*P - 4*D >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Paul:", P.x)
    print("Hours worked by Dale:", D.x)
else:
    print("No optimal solution found")
