
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Paul", lb=0)  # Assuming non-negative hours
    x1 = model.addVar(name="hours_worked_by_Dale", lb=0)  # Assuming non-negative hours

    # Objective function: Maximize 3*x0 + x1
    model.setObjective(3*x0 + x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(14*x0 <= 14, name="quit_index_paul")
    model.addConstr(21*x0 <= 21, name="work_quality_paul")
    model.addConstr(7*x1 <= 7, name="quit_index_dale")
    model.addConstr(13*x1 <= 13, name="work_quality_dale")
    model.addConstr(14*x0 + 7*x1 >= 77, name="combined_quit_index_min")
    model.addConstr(21*x0 + 13*x1 >= 39, name="combined_work_quality_min")
    model.addConstr(9*x0 - 4*x1 >= 0, name="hours_worked_constraint")
    model.addConstr(14*x0 + 7*x1 <= 130, name="combined_quit_index_max")
    model.addConstr(21*x0 + 13*x1 <= 116, name="combined_work_quality_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Paul: ", x0.varValue)
        print("Hours worked by Dale: ", x1.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
