
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="milligrams of vitamin B2")  # milligrams of vitamin B2
x1 = m.addVar(lb=0, name="milligrams of vitamin B3")  # milligrams of vitamin B3
x2 = m.addVar(lb=0, name="milligrams of zinc")  # milligrams of zinc
x3 = m.addVar(lb=0, name="grams of fiber")  # grams of fiber

# Define the objective function
m.setObjective(8*x0 + 4*x1 + 8*x2 + 9*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 <= 195, name="kidney_support_index_vitamin_B2")
m.addConstr(13*x0 <= 270, name="cognitive_performance_index_vitamin_B2")
m.addConstr(6*x0 <= 168, name="digestive_support_index_vitamin_B2")
m.addConstr(4*x0 <= 207, name="immune_support_index_vitamin_B2")

m.addConstr(5*x1 <= 195, name="kidney_support_index_vitamin_B3")
m.addConstr(10*x1 <= 270, name="cognitive_performance_index_vitamin_B3")
m.addConstr(5*x1 <= 168, name="digestive_support_index_vitamin_B3")
m.addConstr(10*x1 <= 207, name="immune_support_index_vitamin_B3")

m.addConstr(6*x2 <= 195, name="kidney_support_index_zinc")
m.addConstr(12*x2 <= 270, name="cognitive_performance_index_zinc")
m.addConstr(11*x2 <= 168, name="digestive_support_index_zinc")
m.addConstr(8*x2 <= 207, name="immune_support_index_zinc")

m.addConstr(11*x3 <= 195, name="kidney_support_index_fiber")
m.addConstr(2*x3 <= 270, name="cognitive_performance_index_fiber")
m.addConstr(12*x3 <= 168, name="digestive_support_index_fiber")
m.addConstr(8*x3 <= 207, name="immune_support_index_fiber")

m.addConstr(5*x1 + 11*x3 >= 33, name="kidney_support_index_vitamin_B3_fiber")
m.addConstr(2*x0 + 6*x2 >= 37, name="kidney_support_index_vitamin_B2_zinc")
m.addConstr(6*x2 + 11*x3 >= 45, name="kidney_support_index_zinc_fiber")
m.addConstr(5*x1 + 6*x2 >= 39, name="kidney_support_index_vitamin_B3_zinc")
m.addConstr(2*x0 + 6*x2 + 11*x3 >= 39, name="kidney_support_index_vitamin_B2_zinc_fiber")
m.addConstr(2*x0 + 5*x1 + 11*x3 >= 39, name="kidney_support_index_vitamin_B2_vitamin_B3_fiber")
m.addConstr(2*x0 + 6*x2 + 11*x3 >= 40, name="kidney_support_index_vitamin_B2_zinc_fiber_2")
m.addConstr(2*x0 + 5*x1 + 11*x3 >= 40, name="kidney_support_index_vitamin_B2_vitamin_B3_fiber_2")
m.addConstr(2*x0 + 5*x1 + 6*x2 + 11*x3 >= 40, name="kidney_support_index_all")

m.addConstr(13*x0 + 2*x3 >= 52, name="cognitive_performance_index_vitamin_B2_fiber")
m.addConstr(10*x1 + 2*x3 >= 33, name="cognitive_performance_index_vitamin_B3_fiber")
m.addConstr(12*x2 + 2*x3 >= 45, name="cognitive_performance_index_zinc_fiber")
m.addConstr(13*x0 + 12*x2 >= 49, name="cognitive_performance_index_vitamin_B2_zinc")
m.addConstr(10*x1 + 12*x2 + 2*x3 >= 49, name="cognitive_performance_index_vitamin_B3_zinc_fiber")
m.addConstr(13*x0 + 10*x1 + 12*x2 + 2*x3 >= 49, name="cognitive_performance_index_all")

m.addConstr(11*x2 + 12*x3 >= 35, name="digestive_support_index_zinc_fiber")
m.addConstr(5*x1 + 11*x2 >= 27, name="digestive_support_index_vitamin_B3_zinc")
m.addConstr(6*x0 + 5*x1 + 11*x2 + 12*x3 >= 27, name="digestive_support_index_all")

m.addConstr(4*x0 + 8*x2 >= 37, name="immune_support_index_vitamin_B2_zinc")
m.addConstr(4*x0 + 8*x3 >= 37, name="immune_support_index_vitamin_B2_fiber")
m.addConstr(10*x1 + 8*x2 >= 29, name="immune_support_index_vitamin_B3_zinc")
m.addConstr(8*x2 + 8*x3 >= 35, name="immune_support_index_zinc_fiber")
m.addConstr(4*x0 + 10*x1 >= 43, name="immune_support_index_vitamin_B2_vitamin_B3")
m.addConstr(10*x1 + 8*x3 >= 26, name="immune_support_index_vitamin_B3_fiber")
m.addConstr(10*x1 + 8*x2 + 8*x3 >= 32, name="immune_support_index_vitamin_B3_zinc_fiber")
m.addConstr(4*x0 + 10*x1 + 8*x2 >= 32, name="immune_support_index_vitamin_B2_vitamin_B3_zinc")
m.addConstr(10*x1 + 8*x2 + 8*x3 >= 27, name="immune_support_index_vitamin_B3_zinc_fiber_2")
m.addConstr(4*x0 + 10*x1 + 8*x2 >= 27, name="immune_support_index_vitamin_B2_vitamin_B3_zinc_2")
m.addConstr(4*x0 + 10*x1 + 8*x2 + 8*x3 >= 27, name="immune_support_index_all")

m.addConstr(-8*x2 + 10*x3 >= 0, name="zinc_fiber_constraint")
m.addConstr(5*x0 - 2*x2 >= 0, name="vitamin_B2_zinc_constraint")

m.addConstr(2*x0 + 5*x1 + 11*x3 <= 105, name="kidney_support_index_vitamin_B2_vitamin_B3_fiber_upper")
m.addConstr(5*x1 + 6*x2 + 11*x3 <= 74, name="kidney_support_index_vitamin_B3_zinc_fiber_upper")
m.addConstr(2*x0 + 6*x2 + 11*x3 <= 132, name="kidney_support_index_vitamin_B2_zinc_fiber_upper")

m.addConstr(10*x1 + 2*x3 <= 70, name="cognitive_performance_index_vitamin_B3_fiber_upper")
m.addConstr(10*x1 + 12*x2 <= 169, name="cognitive_performance_index_vitamin_B3_zinc_upper")
m.addConstr(13*x0 + 12*x2 <= 186, name="cognitive_performance_index_vitamin_B2_zinc_upper")
m.addConstr(13*x0 + 12*x2 + 2*x3 <= 238, name="cognitive_performance_index_vitamin_B2_zinc_fiber_upper")

m.addConstr(5*x1 + 11*x2 + 12*x3 <= 85, name="digestive_support_index_vitamin_B3_zinc_fiber_upper")
m.addConstr(6*x0 + 5*x1 + 12*x3 <= 157, name="digestive_support_index_vitamin_B2_vitamin_B3_fiber_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B2: ", x0.varValue)
    print("Milligrams of vitamin B3: ", x1.varValue)
    print("Milligrams of zinc: ", x2.varValue)
    print("Grams of fiber: ", x3.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
