
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_potassium", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_vitamin_B3", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, integrality=gp.GRB.INTEGER)
x2 = m.addVar(name="milligrams_of_zinc", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
m.setObjective(8.92 * x0 + 6.55 * x1 + 4.0 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(15 * x0 <= 93, name="immune_support_index_potassium")
m.addConstr(7 * x0 <= 146, name="digestive_support_index_potassium")
m.addConstr(7 * x0 <= 146, name="muscle_growth_index_potassium")
m.addConstr(8 * x0 <= 253, name="energy_stability_index_potassium")
m.addConstr(1 * x0 <= 110, name="cardiovascular_support_index_potassium")

m.addConstr(2 * x1 <= 93, name="immune_support_index_vitamin_B3")
m.addConstr(5 * x1 <= 146, name="digestive_support_index_vitamin_B3")
m.addConstr(9 * x1 <= 146, name="muscle_growth_index_vitamin_B3")
m.addConstr(10 * x1 <= 253, name="energy_stability_index_vitamin_B3")
m.addConstr(12 * x1 <= 110, name="cardiovascular_support_index_vitamin_B3")

m.addConstr(13 * x2 <= 93, name="immune_support_index_zinc")
m.addConstr(10 * x2 <= 146, name="digestive_support_index_zinc")
m.addConstr(16 * x2 <= 146, name="muscle_growth_index_zinc")
m.addConstr(17 * x2 <= 253, name="energy_stability_index_zinc")
m.addConstr(10 * x2 <= 110, name="cardiovascular_support_index_zinc")

m.addConstr(15 * x0 + 13 * x2 >= 10, name="combined_immune_support_index_potassium_zinc")
m.addConstr(2 * x1 + 13 * x2 >= 27, name="combined_immune_support_index_vitamin_B3_zinc")
m.addConstr(15 * x0 + 2 * x1 + 13 * x2 >= 19, name="combined_immune_support_index_all")

m.addConstr(7 * x0 + 5 * x1 + 10 * x2 >= 43, name="combined_digestive_support_index_all")
m.addConstr(7 * x0 + 10 * x2 >= 24, name="combined_digestive_support_index_potassium_zinc")
m.addConstr(7 * x0 + 5 * x1 >= 17, name="combined_digestive_support_index_potassium_vitamin_B3")
m.addConstr(7 * x0 + 5 * x1 + 10 * x2 >= 17, name="combined_digestive_support_index_all_2")

m.addConstr(7 * x0 + 16 * x2 >= 42, name="combined_muscle_growth_index_potassium_zinc")
m.addConstr(7 * x0 + 9 * x1 >= 30, name="combined_muscle_growth_index_potassium_vitamin_B3")
m.addConstr(9 * x1 + 16 * x2 >= 25, name="combined_muscle_growth_index_vitamin_B3_zinc")
m.addConstr(7 * x0 + 9 * x1 + 16 * x2 >= 36, name="combined_muscle_growth_index_all")

m.addConstr(10 * x1 + 17 * x2 >= 64, name="combined_energy_stability_index_vitamin_B3_zinc")
m.addConstr(8 * x0 + 10 * x1 >= 70, name="combined_energy_stability_index_potassium_vitamin_B3")
m.addConstr(8 * x0 + 17 * x2 >= 56, name="combined_energy_stability_index_potassium_zinc")
m.addConstr(8 * x0 + 10 * x1 + 17 * x2 >= 56, name="combined_energy_stability_index_all")

m.addConstr(1 * x0 + 10 * x2 >= 36, name="combined_cardiovascular_support_index_potassium_zinc")
m.addConstr(1 * x0 + 12 * x1 >= 29, name="combined_cardiovascular_support_index_potassium_vitamin_B3")
m.addConstr(1 * x0 + 12 * x1 + 10 * x2 >= 29, name="combined_cardiovascular_support_index_all")

m.addConstr(4 * x0 - 7 * x1 >= 0, name="potassium_vitamin_B3_relation")

m.addConstr(15 * x0 + 13 * x2 <= 58, name="combined_immune_support_index_potassium_zinc_upper")
m.addConstr(15 * x0 + 2 * x1 <= 88, name="combined_immune_support_index_potassium_vitamin_B3_upper")
m.addConstr(8 * x0 + 17 * x2 <= 147, name="combined_energy_stability_index_potassium_zinc_upper")
m.addConstr(8 * x0 + 10 * x1 <= 213, name="combined_energy_stability_index_potassium_vitamin_B3_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of potassium: ", x0.varValue)
    print("Milligrams of vitamin B3: ", x1.varValue)
    print("Milligrams of zinc: ", x2.varValue)
else:
    print("The model is infeasible")
