
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Define variables
hank = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Hank")
paul = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
mary = model.addVar(lb=0, vtype=GRB.INTEGER, name="Mary")
ringo = model.addVar(lb=0, vtype=GRB.INTEGER, name="Ringo")
jean = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean")
john = model.addVar(lb=0, vtype=GRB.INTEGER, name="John")

# Set objective function
model.setObjective(1.73 * hank + 1.02 * paul + 2.71 * mary + 3.81 * ringo + 9.75 * jean + 3.15 * john, GRB.MINIMIZE)

# Add constraints
model.addConstr(17 * paul + 8 * ringo >= 32, "c1")
model.addConstr(5 * hank + 17 * paul >= 22, "c2")
model.addConstr(8 * ringo + 7 * jean >= 18, "c3")
model.addConstr(5 * hank + 8 * ringo >= 19, "c4")
model.addConstr(17 * paul + 1 * mary >= 13, "c5")
model.addConstr(7 * jean + 5 * john >= 29, "c6")
model.addConstr(1 * mary + 5 * john >= 31, "c7")
model.addConstr(17 * paul + 5 * john >= 10, "c8")
model.addConstr(5 * hank + 5 * john >= 13, "c9")
model.addConstr(5 * hank + 7 * jean >= 12, "c10")
model.addConstr(8 * ringo + 5 * john >= 29, "c11")
model.addConstr(5 * hank + 17 * paul + 1 * mary + 8 * ringo + 7 * jean + 5 * john >= 29, "c12")
model.addConstr(12 * mary + 14 * john >= 16, "c13")
model.addConstr(12 * mary + 8 * ringo >= 27, "c14")
model.addConstr(19 * hank + 18 * paul + 12 * mary + 8 * ringo + 17 * jean + 14 * john >= 27, "c15")
model.addConstr(2 * paul - 3 * jean >= 0, "c16")
model.addConstr(8 * hank - 2 * jean >= 0, "c17")
model.addConstr(6 * paul - 3 * john >= 0, "c18")

model.addConstr(17 * paul + 1 * mary <= 122, "c19")
model.addConstr(5 * hank + 1 * mary <= 149, "c20")
model.addConstr(5 * hank + 7 * jean <= 110, "c21")
model.addConstr(17 * paul + 8 * ringo <= 36, "c22")
model.addConstr(8 * ringo + 5 * john <= 84, "c23")
model.addConstr(1 * mary + 5 * john <= 37, "c24")
model.addConstr(17 * paul + 5 * john <= 72, "c25")
model.addConstr(8 * ringo + 7 * jean <= 38, "c26")
model.addConstr(18 * paul + 12 * mary + 17 * jean <= 69, "c27")
model.addConstr(18 * paul + 17 * jean + 14 * john <= 81, "c28")
model.addConstr(19 * hank + 17 * jean + 14 * john <= 83, "c29")
model.addConstr(19 * hank + 18 * paul + 17 * jean <= 200, "c30")
model.addConstr(19 * hank + 18 * paul + 8 * ringo <= 45, "c31")
model.addConstr(19 * hank + 12 * mary + 17 * jean <= 59, "c32")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

