
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    H = model.addVar(lb=0, name="H")  # Hank
    P = model.addVar(lb=0, name="P")  # Paul
    M = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="M")  # Mary
    R = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="R")  # Ringo
    J = model.addVar(lb=0, name="J")  # Jean
    Y = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Y")  # John

    # Objective function
    model.setObjective(1.73 * H + 1.02 * P + 2.71 * M + 3.81 * R + 9.75 * J + 3.15 * Y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * H <= 192)
    model.addConstr(19 * H <= 202)
    model.addConstr(17 * P <= 192)
    model.addConstr(18 * P <= 202)
    model.addConstr(1 * M <= 192)
    model.addConstr(12 * M <= 202)
    model.addConstr(8 * R <= 192)
    model.addConstr(8 * R <= 202)
    model.addConstr(7 * J <= 192)
    model.addConstr(17 * J <= 202)
    model.addConstr(5 * Y <= 192)
    model.addConstr(14 * Y <= 202)

    model.addConstr(17 * P + 8 * R >= 32)
    model.addConstr(5 * H + 17 * P >= 22)
    model.addConstr(8 * R + 7 * J >= 18)
    model.addConstr(5 * H + 8 * R >= 19)
    model.addConstr(17 * P + 1 * M >= 13)
    model.addConstr(7 * J + 5 * Y >= 29)
    model.addConstr(1 * M + 5 * Y >= 31)
    model.addConstr(17 * P + 5 * Y >= 10)
    model.addConstr(5 * H + 5 * Y >= 13)
    model.addConstr(5 * H + 7 * J >= 12)
    model.addConstr(8 * R + 5 * Y >= 29)
    model.addConstr(5 * H + 17 * P + 1 * M + 8 * R + 7 * J + 5 * Y >= 29)

    model.addConstr(12 * M + 14 * Y >= 16)
    model.addConstr(12 * M + 8 * R >= 27)
    model.addConstr(19 * H + 18 * P + 12 * M + 8 * R + 17 * J + 14 * Y >= 27)

    model.addConstr(2 * P - 3 * J >= 0)
    model.addConstr(8 * H - 2 * J >= 0)
    model.addConstr(6 * P - 3 * Y >= 0)

    model.addConstr(17 * P + 1 * M <= 122)
    model.addConstr(5 * H + 1 * M <= 149)
    model.addConstr(5 * H + 7 * J <= 110)
    model.addConstr(17 * P + 8 * R <= 36)
    model.addConstr(8 * R + 5 * Y <= 84)
    model.addConstr(1 * M + 5 * Y <= 37)
    model.addConstr(17 * P + 5 * Y <= 72)
    model.addConstr(8 * R + 7 * J <= 38)

    model.addConstr(18 * P + 12 * M + 17 * J <= 69)
    model.addConstr(18 * P + 17 * J + 14 * Y <= 81)
    model.addConstr(19 * H + 17 * J + 14 * Y <= 83)
    model.addConstr(19 * H + 18 * P + 17 * J <= 200)
    model.addConstr(19 * H + 18 * P + 8 * R <= 45)
    model.addConstr(19 * H + 12 * M + 17 * J <= 59)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hank: ", H.varValue)
        print("Paul: ", P.varValue)
        print("Mary: ", M.varValue)
        print("Ringo: ", R.varValue)
        print("Jean: ", J.varValue)
        print("John: ", Y.varValue)
    else:
        print("No solution found")

optimize_problem()
