
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
coffee = m.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")
rubber_bands = m.addVar(vtype=GRB.INTEGER, name="rubber_bands")
headsets = m.addVar(vtype=GRB.INTEGER, name="headsets")

# Set objective function
m.setObjective(9 * coffee + 8 * rubber_bands + 6 * headsets, GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * coffee + 16 * rubber_bands >= 52, "c1")
m.addConstr(16 * rubber_bands + 13 * headsets >= 30, "c2")
m.addConstr(17 * coffee + 16 * rubber_bands + 13 * headsets >= 40, "c3")
m.addConstr(6 * coffee - 2 * headsets >= 0, "c4")
m.addConstr(16 * rubber_bands + 13 * headsets <= 157, "c5")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cans_of_coffee:', coffee.x)
    print('rubber_bands:', rubber_bands.x)
    print('headsets:', headsets.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

