
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")
x1 = m.addVar(vtype=GRB.INTEGER, name="rubber_bands")
x2 = m.addVar(vtype=GRB.INTEGER, name="headsets")

# Objective function: Minimize 9*x0 + 8*x1 + 6*x2
m.setObjective(9*x0 + 8*x1 + 6*x2, GRB.MINIMIZE)

# Constraints
# Minimum total usefulness rating from cans of coffee plus rubber bands
m.addConstr(17*x0 + 16*x1 >= 52, name="usefulness_coffee_rubber")

# Minimum total usefulness rating from rubber bands plus headsets
m.addConstr(16*x1 + 13*x2 >= 30, name="usefulness_rubber_headsets")

# Minimum total combined usefulness rating from all items
m.addConstr(17*x0 + 16*x1 + 13*x2 >= 40, name="total_usefulness_min")

# Constraint on the combination of cans of coffee and headsets
m.addConstr(6*x0 - 2*x2 >= 0, name="coffee_headsets_constraint")

# Maximum total usefulness rating from rubber bands plus headsets
m.addConstr(16*x1 + 13*x2 <= 157, name="usefulness_rubber_headsets_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"cans_of_coffee: {x0.x}")
    print(f"rubber_bands: {x1.x}")
    print(f"headsets: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
