
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    cans_of_coffee = model.addVar(name="cans_of_coffee", vtype=gurobi.GRB.INTEGER)
    rubber_bands = model.addVar(name="rubber_bands", vtype=gurobi.GRB.INTEGER)
    headsets = model.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9 * cans_of_coffee + 8 * rubber_bands + 6 * headsets, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17 * cans_of_coffee + 16 * rubber_bands >= 52)
    model.addConstr(16 * rubber_bands + 13 * headsets >= 30)
    model.addConstr(17 * cans_of_coffee + 16 * rubber_bands + 13 * headsets >= 40)
    model.addConstr(6 * cans_of_coffee - 2 * headsets >= 0)
    model.addConstr(16 * rubber_bands + 13 * headsets <= 157)

    # Set bounds based on usefulness ratings (not necessary but for clarity)
    model.addConstr(cans_of_coffee >= 0)
    model.addConstr(rubber_bands >= 0)
    model.addConstr(headsets >= 0)

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cans of Coffee: {cans_of_coffee.varValue}")
        print(f"Rubber Bands: {rubber_bands.varValue}")
        print(f"Headsets: {headsets.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible")
    else:
        print("The model has a non-optimal status")

solve_optimization_problem()
