
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_a = m.addVar(name="vitamin_a")
vitamin_b5 = m.addVar(name="vitamin_b5")
iron = m.addVar(name="iron")
vitamin_b3 = m.addVar(name="vitamin_b3")
carbohydrates = m.addVar(name="carbohydrates")

# Set objective function
m.setObjective(1.84 * vitamin_a**2 + 7.25 * vitamin_a * vitamin_b5 + 2.77 * vitamin_a * vitamin_b3 + 8.72 * vitamin_b5**2 + 7.42 * vitamin_b5 * vitamin_b3 + 2.54 * vitamin_b5 * carbohydrates + 9.88 * iron**2 + 5.3 * iron * carbohydrates + 3.67 * vitamin_b3**2 + 3.94 * vitamin_b3 * carbohydrates + 8.96 * carbohydrates**2 + 7.01 * iron + 6.55 * carbohydrates, gp.GRB.MAXIMIZE)

# Add constraints
kidney_support_index = {'vitamin_a': 19, 'vitamin_b5': 15, 'iron': 16, 'vitamin_b3': 11, 'carbohydrates': 10}
m.addConstr(15 * vitamin_b5 + 10 * carbohydrates >= 42)
m.addConstr(15 * vitamin_b5 + 16 * iron >= 32)
m.addConstr(16 * iron**2 + 11 * vitamin_b3**2 >= 24)
m.addConstr(16 * iron + 10 * carbohydrates >= 47)
m.addConstr(15 * vitamin_b5**2 + 11 * vitamin_b3**2 >= 21)
m.addConstr(19 * vitamin_a + 11 * vitamin_b3 >= 23)
m.addConstr(19 * vitamin_a**2 + 15 * vitamin_b5**2 + 16 * iron**2 >= 30)
m.addConstr(15 * vitamin_b5 + 16 * iron + 11 * vitamin_b3 >= 30)
m.addConstr(16 * iron + 11 * vitamin_b3 + 10 * carbohydrates >= 30)
m.addConstr(19 * vitamin_a + 15 * vitamin_b5 + 16 * iron >= 23)
m.addConstr(15 * vitamin_b5**2 + 16 * iron**2 + 11 * vitamin_b3**2 >= 23)
m.addConstr(16 * iron + 11 * vitamin_b3 + 10 * carbohydrates >= 23)
m.addConstr(19 * vitamin_a + 15 * vitamin_b5 + 16 * iron >= 42)
m.addConstr(15 * vitamin_b5 + 16 * iron + 11 * vitamin_b3 >= 42)
m.addConstr(16 * iron + 11 * vitamin_b3 + 10 * carbohydrates >= 42)
m.addConstr(6 * vitamin_a - 10 * carbohydrates >= 0)
m.addConstr(11 * vitamin_b3 + 10 * carbohydrates <= 218)
m.addConstr(19 * vitamin_a + 15 * vitamin_b5 <= 189)
m.addConstr(15 * vitamin_b5**2 + 16 * iron**2 + 10 * carbohydrates**2 <= 190)
m.addConstr(16 * iron**2 + 11 * vitamin_b3**2 + 10 * carbohydrates**2 <= 140)
m.addConstr(15 * vitamin_b5 + 11 * vitamin_b3 + 10 * carbohydrates <= 118)
m.addConstr(19 * vitamin_a**2 + 15 * vitamin_b5**2 + 16 * iron**2 <= 151)
m.addConstr(15 * vitamin_b5 + 16 * iron + 11 * vitamin_b3 <= 95)
m.addConstr(19 * vitamin_a + 15 * vitamin_b5 + 16 * iron + 11 * vitamin_b3 + 10 * carbohydrates <= 95)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

