
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_vitamin_A", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_vitamin_B5", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_iron", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams_of_vitamin_B3", lb=-gp.GRB.INFINITY)
x4 = m.addVar(name="grams_of_carbohydrates", lb=-gp.GRB.INFINITY)

# Objective function
m.setObjective(1.84*x0**2 + 7.25*x0*x1 + 2.77*x0*x3 + 8.72*x1**2 + 7.42*x1*x3 + 2.54*x1*x4 + 
               9.88*x2**2 + 5.3*x2*x4 + 3.67*x3**2 + 3.94*x3*x4 + 8.96*x4**2 + 7.01*x2 + 6.55*x4, 
               sense=gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(19*x0 <= 237)
m.addConstr(15*x1 <= 237)
m.addConstr(16*x2 <= 237)
m.addConstr(11*x3 <= 237)
m.addConstr(10*x4 <= 237)

m.addConstr(15*x1 + 10*x4 >= 42)
m.addConstr(15*x1 + 16*x2 >= 32)
m.addConstr(16*x2**2 + 11*x3**2 >= 24)
m.addConstr(16*x2 + 10*x4 >= 47)
m.addConstr(15*x1**2 + 11*x3**2 >= 21)
m.addConstr(19*x0 + 11*x3 >= 23)
m.addConstr(19*x0**2 + 15*x1**2 + 16*x2**2 >= 30)
m.addConstr(15*x1 + 16*x2 + 11*x3 >= 30)
m.addConstr(16*x2 + 11*x3 + 10*x4 >= 30)
m.addConstr(19*x0 + 15*x1 + 16*x2 >= 23)
m.addConstr(15*x1**2 + 16*x2**2 + 11*x3**2 >= 23)
m.addConstr(16*x2 + 11*x3 + 10*x4 >= 23)
m.addConstr(19*x0 + 15*x1 + 16*x2 >= 42)
m.addConstr(15*x1 + 16*x2 + 11*x3 >= 42)
m.addConstr(16*x2 + 11*x3 + 10*x4 >= 42)
m.addConstr(6*x0 - 10*x4 >= 0)
m.addConstr(11*x3 + 10*x4 <= 218)
m.addConstr(19*x0 + 15*x1 <= 189)
m.addConstr(15*x1**2 + 16*x2**2 + 10*x4**2 <= 190)
m.addConstr(16*x2**2 + 11*x3**2 + 10*x4**2 <= 140)
m.addConstr(15*x1 + 11*x3 + 10*x4 <= 118)
m.addConstr(19*x0**2 + 15*x1**2 + 16*x2**2 <= 151)
m.addConstr(15*x1 + 16*x2 + 11*x3 <= 95)
m.addConstr(19*x0 + 15*x1 + 16*x2 + 11*x3 + 10*x4 <= 95)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin A: {x0.varValue}")
    print(f"Milligrams of vitamin B5: {x1.varValue}")
    print(f"Milligrams of iron: {x2.varValue}")
    print(f"Milligrams of vitamin B3: {x3.varValue}")
    print(f"Grams of carbohydrates: {x4.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
