
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource_Optimization")

# Create variables
network_admins = model.addVar(vtype=GRB.INTEGER, name="network_admins")
pen_testers = model.addVar(vtype=GRB.INTEGER, name="pen_testers")
auto_alerts = model.addVar(vtype=GRB.INTEGER, name="auto_alerts")
honeypots = model.addVar(vtype=GRB.INTEGER, name="honeypots")

# Set objective function
model.setObjective(8.9 * network_admins + 9.67 * pen_testers + 9.63 * auto_alerts + 9.12 * honeypots, GRB.MAXIMIZE)

# Add constraints
model.addConstr(8 * network_admins + 7 * pen_testers + 7 * auto_alerts + 8 * honeypots <= 94, "Network Latency")  # r0
model.addConstr(6 * network_admins + 5 * pen_testers + 2 * auto_alerts + 6 * honeypots <= 70, "Power Consumption")  # r1
model.addConstr(7 * network_admins + 4 * pen_testers + 2 * auto_alerts + 1 * honeypots <= 89, "Data Accessibility")  # r2
model.addConstr(2 * network_admins + 4 * pen_testers + 6 * auto_alerts + 5 * honeypots <= 39, "Network Integrity")  # r3

model.addConstr(7 * pen_testers + 8 * honeypots >= 17, "Latency_PenTesters_Honeypots")
model.addConstr(7 * pen_testers + 7 * auto_alerts >= 13, "Latency_PenTesters_AutoAlerts")
model.addConstr(8 * network_admins + 7 * auto_alerts >= 9, "Latency_NetworkAdmins_AutoAlerts")

model.addConstr(2 * auto_alerts + 6 * honeypots >= 17, "Power_AutoAlerts_Honeypots")
model.addConstr(6 * network_admins + 5 * pen_testers >= 13, "Power_NetworkAdmins_PenTesters")
model.addConstr(6 * network_admins + 5 * pen_testers + 6 * honeypots >= 10, "Power_NetworkAdmins_PenTesters_Honeypots")

model.addConstr(4 * pen_testers + 2 * auto_alerts >= 8, "DataAccessibility_PenTesters_AutoAlerts")
model.addConstr(4 * pen_testers + 1 * honeypots >= 16, "DataAccessibility_PenTesters_Honeypots")

model.addConstr(2 * network_admins + 6 * auto_alerts >= 7, "NetworkIntegrity_NetworkAdmins_AutoAlerts")
model.addConstr(4 * pen_testers + 6 * auto_alerts >= 9, "NetworkIntegrity_PenTesters_AutoAlerts")
model.addConstr(2 * network_admins + 5 * honeypots >= 4, "NetworkIntegrity_NetworkAdmins_Honeypots")
model.addConstr(4 * pen_testers + 5 * honeypots >= 6, "NetworkIntegrity_PenTesters_Honeypots")


model.addConstr(2 * pen_testers - 10 * auto_alerts + 3 * honeypots >= 0, "Custom_Constraint_1")

#Max Constraints
model.addConstr(7 * pen_testers + 8 * honeypots <= 35, "Max_Latency_PenTesters_Honeypots")
model.addConstr(8 * network_admins + 8 * honeypots <= 71, "Max_Latency_NetworkAdmins_Honeypots")
model.addConstr(7 * auto_alerts + 8 * honeypots <= 49, "Max_Latency_AutoAlerts_Honeypots")
model.addConstr(8 * network_admins + 7 * pen_testers + 7 * auto_alerts + 8 * honeypots <= 49, "Max_Latency_All")

model.addConstr(2 * auto_alerts + 6 * honeypots <= 40, "Max_Power_AutoAlerts_Honeypots")
model.addConstr(6 * network_admins + 6 * honeypots <= 18, "Max_Power_NetworkAdmins_Honeypots")
model.addConstr(5 * pen_testers + 6 * honeypots <= 41, "Max_Power_PenTesters_Honeypots")
model.addConstr(6 * network_admins + 5 * pen_testers <= 69, "Max_Power_NetworkAdmins_PenTesters")
model.addConstr(5 * pen_testers + 2 * auto_alerts + 6 * honeypots <= 52, "Max_Power_PenTesters_AutoAlerts_Honeypots")
model.addConstr(6 * network_admins + 5 * pen_testers + 2 * auto_alerts + 6 * honeypots <= 52, "Max_Power_All")

model.addConstr(4 * pen_testers + 1 * honeypots <= 86, "Max_DataAccessibility_PenTesters_Honeypots")
model.addConstr(4 * pen_testers + 2 * auto_alerts <= 31, "Max_DataAccessibility_PenTesters_AutoAlerts")
model.addConstr(2 * auto_alerts + 1 * honeypots <= 23, "Max_DataAccessibility_AutoAlerts_Honeypots")
model.addConstr(7 * network_admins + 4 * pen_testers + 2 * auto_alerts <= 51, "Max_DataAccessibility_NetworkAdmins_PenTesters_AutoAlerts")
model.addConstr(4 * pen_testers + 2 * auto_alerts + 1 * honeypots <= 63, "Max_DataAccessibility_PenTesters_AutoAlerts_Honeypots")
model.addConstr(7 * network_admins + 4 * pen_testers + 1 * honeypots <= 67, "Max_DataAccessibility_NetworkAdmins_PenTesters_Honeypots")
model.addConstr(7 * network_admins + 4 * pen_testers + 2 * auto_alerts + 1 * honeypots <= 67, "Max_DataAccessibility_All")


model.addConstr(4 * pen_testers + 6 * auto_alerts <= 39, "Max_NetworkIntegrity_PenTesters_AutoAlerts")
model.addConstr(2 * network_admins + 4 * pen_testers <= 37, "Max_NetworkIntegrity_NetworkAdmins_PenTesters")
model.addConstr(4 * pen_testers + 5 * honeypots <= 21, "Max_NetworkIntegrity_PenTesters_Honeypots")
model.addConstr(2 * network_admins + 4 * pen_testers + 6 * auto_alerts <= 30, "Max_NetworkIntegrity_NetworkAdmins_PenTesters_AutoAlerts")
model.addConstr(2 * network_admins + 6 * auto_alerts + 5 * honeypots <= 19, "Max_NetworkIntegrity_NetworkAdmins_AutoAlerts_Honeypots")
model.addConstr(2 * network_admins + 4 * pen_testers + 5 * honeypots <= 31, "Max_NetworkIntegrity_NetworkAdmins_PenTesters_Honeypots")
model.addConstr(2 * network_admins + 4 * pen_testers + 6 * auto_alerts + 5 * honeypots <= 31, "Max_NetworkIntegrity_All")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('\nObjective Value: ', model.objVal)
    print('\nSolution:')
    for v in model.getVars():
        print(f'{v.varName}: {v.x}')
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

