
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")

# Define the objective function
m.setObjective(8.9*x0 + 9.67*x1 + 9.63*x2 + 9.12*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x0 + 7*x1 + 7*x2 + 8*x3 <= 94, "network_latency_impact")
m.addConstr(6*x0 + 5*x1 + 2*x2 + 6*x3 <= 70, "power_consumption")
m.addConstr(7*x0 + 4*x1 + 2*x2 + x3 <= 89, "data_accessibility_impact")
m.addConstr(2*x0 + 4*x1 + 6*x2 + 5*x3 <= 39, "network_integrity_impact")

m.addConstr(7*x1 + 8*x3 >= 17, "network_latency_pen_testers_honeypots")
m.addConstr(7*x1 + 7*x2 >= 13, "network_latency_pen_testers_automatic_alerts")
m.addConstr(8*x0 + 7*x2 >= 9, "network_latency_network_administrators_automatic_alerts")
m.addConstr(2*x2 + 6*x3 >= 17, "power_consumption_automatic_alerts_honeypots")
m.addConstr(6*x0 + 5*x1 >= 13, "power_consumption_network_administrators_pen_testers")
m.addConstr(6*x0 + 5*x1 + 6*x3 >= 10, "power_consumption_network_administrators_pen_testers_honeypots")

m.addConstr(4*x1 + 2*x2 >= 8, "data_accessibility_impact_pen_testers_automatic_alerts")
m.addConstr(4*x1 + x3 >= 16, "data_accessibility_impact_pen_testers_honeypots")
m.addConstr(2*x0 + 6*x2 >= 7, "network_integrity_impact_network_administrators_automatic_alerts")
m.addConstr(4*x1 + 6*x2 >= 9, "network_integrity_impact_pen_testers_automatic_alerts")
m.addConstr(2*x0 + 5*x3 >= 4, "network_integrity_impact_network_administrators_honeypots")
m.addConstr(4*x1 + 5*x3 >= 6, "network_integrity_impact_pen_testers_honeypots")

m.addConstr(2*x1 - 10*x2 + 3*x3 >= 0, "custom_constraint")

m.addConstr(7*x1 + 8*x3 <= 35, "network_latency_pen_testers_honeypots_upper")
m.addConstr(8*x0 + 8*x3 <= 71, "network_latency_network_administrators_honeypots_upper")
m.addConstr(7*x2 + 8*x3 <= 49, "network_latency_automatic_alerts_honeypots_upper")
m.addConstr(8*x0 + 7*x1 + 7*x2 + 8*x3 <= 49, "network_latency_upper")

m.addConstr(2*x2 + 6*x3 <= 40, "power_consumption_automatic_alerts_honeypots_upper")
m.addConstr(6*x0 + 6*x3 <= 18, "power_consumption_network_administrators_honeypots_upper")
m.addConstr(5*x1 + 6*x3 <= 41, "power_consumption_pen_testers_honeypots_upper")
m.addConstr(6*x0 + 5*x1 <= 69, "power_consumption_network_administrators_pen_testers_upper")
m.addConstr(5*x1 + 2*x2 + 6*x3 <= 52, "power_consumption_pen_testers_automatic_alerts_honeypots_upper")
m.addConstr(6*x0 + 5*x1 + 2*x2 + 6*x3 <= 52, "power_consumption_upper")

m.addConstr(4*x1 + 2*x2 <= 86, "data_accessibility_impact_pen_testers_automatic_alerts_upper")
m.addConstr(4*x1 + 2*x2 <= 31, "data_accessibility_impact_pen_testers_automatic_alerts_upper_2")
m.addConstr(2*x2 + x3 <= 23, "data_accessibility_impact_automatic_alerts_honeypots_upper")
m.addConstr(7*x0 + 4*x1 + 2*x2 <= 51, "data_accessibility_impact_network_administrators_pen_testers_automatic_alerts_upper")
m.addConstr(4*x1 + 2*x2 + x3 <= 63, "data_accessibility_impact_pen_testers_automatic_alerts_honeypots_upper")
m.addConstr(7*x0 + 4*x1 + x3 <= 67, "data_accessibility_impact_network_administrators_pen_testers_honeypots_upper")
m.addConstr(7*x0 + 4*x1 + 2*x2 + x3 <= 67, "data_accessibility_impact_upper")

m.addConstr(4*x1 + 6*x2 <= 39, "network_integrity_impact_pen_testers_automatic_alerts_upper")
m.addConstr(2*x0 + 4*x1 <= 37, "network_integrity_impact_network_administrators_pen_testers_upper")
m.addConstr(4*x1 + 5*x3 <= 21, "network_integrity_impact_pen_testers_honeypots_upper")
m.addConstr(2*x0 + 4*x1 + 6*x2 <= 30, "network_integrity_impact_network_administrators_pen_testers_automatic_alerts_upper")
m.addConstr(2*x0 + 6*x2 + 5*x3 <= 19, "network_integrity_impact_network_administrators_automatic_alerts_honeypots_upper")
m.addConstr(2*x0 + 4*x1 + 5*x3 <= 31, "network_integrity_impact_network_administrators_pen_testers_honeypots_upper")
m.addConstr(2*x0 + 4*x1 + 6*x2 + 5*x3 <= 31, "network_integrity_impact_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Network Administrators: ", x0.varValue)
    print("Pen Testers: ", x1.varValue)
    print("Automatic Alerts: ", x2.varValue)
    print("Honeypots: ", x3.varValue)
else:
    print("No optimal solution found")
