
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")

# Set objective function
m.setObjective(7 * zinc + 5 * vitamin_b2 + 4 * vitamin_b4 + 7 * vitamin_c, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * zinc + 25 * vitamin_b2 >= 47, "c1")
m.addConstr(10 * vitamin_b4 + 16 * vitamin_c >= 44, "c2")
m.addConstr(1 * zinc + 16 * vitamin_c >= 32, "c3")
m.addConstr(1 * zinc + 25 * vitamin_b2 + 16 * vitamin_c >= 38, "c4")
m.addConstr(1 * zinc + 25 * vitamin_b2 + 10 * vitamin_b4 + 16 * vitamin_c >= 38, "c5")
m.addConstr(15 * vitamin_b2 + 8 * vitamin_b4 >= 18, "c6")
m.addConstr(21 * zinc + 8 * vitamin_b4 >= 21, "c7")
m.addConstr(8 * vitamin_b4 + 17 * vitamin_c >= 21, "c8")
m.addConstr(21 * zinc + 15 * vitamin_b2 >= 25, "c9")
m.addConstr(21 * zinc + 15 * vitamin_b2 + 8 * vitamin_b4 + 17 * vitamin_c >= 25, "c10")
m.addConstr(9 * vitamin_b2 - 6 * vitamin_b4 >= 0, "c11")
m.addConstr(10 * zinc - 3 * vitamin_b2 >= 0, "c12")
m.addConstr(1 * zinc + 25 * vitamin_b2 <= 165, "c13")
m.addConstr(25 * vitamin_b2 + 10 * vitamin_b4 <= 79, "c14")
m.addConstr(1 * zinc + 10 * vitamin_b4 <= 224, "c15")
m.addConstr(15 * vitamin_b2 + 8 * vitamin_b4 + 17 * vitamin_c <= 113, "c16")
m.addConstr(21 * zinc + 15 * vitamin_b2 + 8 * vitamin_b4 <= 126, "c17")


# Resource Constraints
m.addConstr(1 * zinc + 25 * vitamin_b2 + 10 * vitamin_b4 + 16 * vitamin_c <= 244, "r0") # Muscle Growth
m.addConstr(21 * zinc + 15 * vitamin_b2 + 8 * vitamin_b4 + 17 * vitamin_c <= 156, "r1") # Energy Stability


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

