
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    z = model.addVar(name="z", lb=0)  # milligrams of zinc
    r2 = model.addVar(name="r2", lb=0)  # milligrams of vitamin B2
    r4 = model.addVar(name="r4", lb=0)  # milligrams of vitamin B4
    rC = model.addVar(name="rC", lb=0)  # milligrams of vitamin C

    # Objective function
    model.setObjective(7 * z + 5 * r2 + 4 * r4 + 7 * rC, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(z + 25 * r2 >= 47)
    model.addConstr(10 * r4 + 16 * rC >= 44)
    model.addConstr(z + 16 * rC >= 32)
    model.addConstr(z + 25 * r2 + 16 * rC >= 38)
    model.addConstr(z + 25 * r2 + 10 * r4 + 16 * rC >= 38)
    model.addConstr(15 * r2 + 8 * r4 >= 18)
    model.addConstr(21 * z + 8 * r4 >= 21)
    model.addConstr(8 * r4 + 17 * rC >= 21)
    model.addConstr(21 * z + 15 * r2 >= 25)
    model.addConstr(21 * z + 15 * r2 + 8 * r4 + 17 * rC >= 25)
    model.addConstr(9 * r2 - 6 * r4 >= 0)
    model.addConstr(10 * z - 3 * r2 >= 0)
    model.addConstr(z + 25 * r2 <= 165)
    model.addConstr(25 * r2 + 10 * r4 <= 79)
    model.addConstr(z + 10 * r4 <= 224)
    model.addConstr(15 * r2 + 8 * r4 + 17 * rC <= 113)
    model.addConstr(21 * z + 15 * r2 + 8 * r4 <= 126)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("z: ", z.varValue)
        print("r2: ", r2.varValue)
        print("r4: ", r4.varValue)
        print("rC: ", rC.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
