
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_a = model.addVar(vtype=GRB.INTEGER, name="vitamin_a")
vitamin_b12 = model.addVar(vtype=GRB.INTEGER, name="vitamin_b12")
calcium = model.addVar(vtype=GRB.CONTINUOUS, name="calcium")

# Set objective function
model.setObjective(5.95 * vitamin_a + 6.95 * vitamin_b12 + 1.06 * calcium, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * vitamin_a + 2 * calcium >= 8, "c1")
model.addConstr(6 * vitamin_a + 3 * vitamin_b12 >= 16, "c2")
model.addConstr(6 * vitamin_a + 3 * vitamin_b12 + 2 * calcium >= 16, "c3")
model.addConstr(-5 * vitamin_a + 9 * calcium >= 0, "c4")
model.addConstr(6 * vitamin_a + 3 * vitamin_b12 + 2 * calcium <= 31, "c5")  # Resource constraint
# model.addConstr(6 * vitamin_a + 3 * vitamin_b12 + 2 * calcium <= 49, "resource_constraint") #Commented out as it is redundant given c5


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Vitamin A: {vitamin_a.x}")
    print(f"  Vitamin B12: {vitamin_b12.x}")
    print(f"  Calcium: {calcium.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

