
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_A", vtype=gurobi.GRB.INTEGER)  # Integer
    x1 = model.addVar(name="milligrams_of_vitamin_B12", vtype=gurobi.GRB.INTEGER)  # Integer
    x2 = model.addVar(name="milligrams_of_calcium")  # Continuous

    # Objective function
    model.setObjective(5.95 * x0 + 6.95 * x1 + 1.06 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * x0 + 2 * x2 >= 8, name="vitamin_A_calcium_muscle_growth")
    model.addConstr(6 * x0 + 3 * x1 >= 16, name="vitamin_A_B12_muscle_growth")
    model.addConstr(6 * x0 + 3 * x1 + 2 * x2 >= 16, name="total_muscle_growth_1")
    model.addConstr(-5 * x0 + 9 * x2 >= 0, name="vitamin_A_calcium_tradeoff")
    model.addConstr(6 * x0 + 3 * x1 + 2 * x2 <= 31, name="total_muscle_growth_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milligrams of Vitamin A: {x0.varValue}")
        print(f"Milligrams of Vitamin B12: {x1.varValue}")
        print(f"Milligrams of Calcium: {x2.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
