
import gurobipy as gp

# Create a new model
m = gp.Model("work_hours_optimization")

# Create variables
laura_hours = m.addVar(lb=0, name="laura_hours")
peggy_hours = m.addVar(lb=0, name="peggy_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale_hours")

# Set objective function
m.setObjective(laura_hours**2 + 6 * peggy_hours**2 + 3 * dale_hours**2 + 8 * peggy_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * laura_hours**2 + 7 * peggy_hours**2 + 1 * dale_hours**2 >= 18, "organization_score_squared")
m.addConstr(-10 * laura_hours + 3 * dale_hours >= 0, "laura_dale_relation")
m.addConstr(5 * peggy_hours + 1 * dale_hours <= 23, "computer_competence_peggy_dale")
m.addConstr(3 * laura_hours + 5 * peggy_hours <= 24, "computer_competence_laura_peggy")
m.addConstr(3 * laura_hours + 5 * peggy_hours + 1 * dale_hours <= 24, "computer_competence_all")
m.addConstr(8 * laura_hours + 1 * dale_hours <= 23, "organization_score_laura_dale")
m.addConstr(7 * peggy_hours + 1 * dale_hours <= 23, "organization_score_peggy_dale")
m.addConstr(8 * laura_hours + 7 * peggy_hours + 1 * dale_hours <= 59, "organization_score_all_1")
m.addConstr(8 * laura_hours + 7 * peggy_hours + 1 * dale_hours <= 59, "organization_score_all_2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Laura hours:', laura_hours.x)
    print('Peggy hours:', peggy_hours.x)
    print('Dale hours:', dale_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

