
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
laura_hours = m.addVar(lb=0, name="laura_hours")  # No upper bound for Laura's hours
peggy_hours = m.addVar(lb=0, name="peggy_hours")  # No upper bound for Peggy's hours
dale_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale_hours")  # Dale works integer hours

# Objective function
m.setObjective(laura_hours**2 + 6 * peggy_hours**2 + 3 * dale_hours**2 + 8 * peggy_hours, gp.GRB.MAXIMIZE)

# Constraints
# 7. Organization score squared >= 18
m.addConstr(laura_hours**2 + peggy_hours**2 + dale_hours**2 >= 18)

# 8. -10 * Laura's hours + 3 * Dale's hours >= 0
m.addConstr(-10 * laura_hours + 3 * dale_hours >= 0)

# 9. Computer competence rating from Peggy and Dale <= 23
m.addConstr(5 * peggy_hours + dale_hours <= 23)

# 10. Computer competence rating from Laura and Peggy <= 24
m.addConstr(3 * laura_hours + 5 * peggy_hours <= 24)

# 11. Computer competence rating from Laura, Peggy, and Dale <= 24
m.addConstr(3 * laura_hours + 5 * peggy_hours + dale_hours <= 24)

# 12. Organization score from Laura and Dale <= 23
m.addConstr(8 * laura_hours + dale_hours <= 23)

# 13. Organization score from Peggy and Dale <= 23
m.addConstr(7 * peggy_hours + dale_hours <= 23)

# 14. Organization score from Laura, Peggy, and Dale <= 59
m.addConstr(8 * laura_hours + 7 * peggy_hours + dale_hours <= 59)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Laura's hours: {laura_hours.varValue}")
    print(f"Peggy's hours: {peggy_hours.varValue}")
    print(f"Dale's hours: {dale_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
