
import gurobipy as gp

# Create a new model
m = gp.Model("maximize_tastiness")

# Create variables
cornichons = m.addVar(lb=0, name="cornichons")
fruit_salads = m.addVar(lb=0, name="fruit_salads")
slices_of_pizza = m.addVar(lb=0, name="slices_of_pizza")
cherry_pies = m.addVar(lb=0, name="cherry_pies")
blueberry_pies = m.addVar(lb=0, name="blueberry_pies")

# Set objective function
m.setObjective(2.02 * cornichons + 2.38 * fruit_salads + 1.8 * slices_of_pizza + 4.35 * cherry_pies + 5.67 * blueberry_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * slices_of_pizza + 26 * blueberry_pies >= 28, "tastiness_constraint1")
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 74, "tastiness_constraint2")
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 74, "tastiness_constraint3")
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 74, "tastiness_constraint4")
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 74, "tastiness_constraint5")
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 69, "tastiness_constraint6")
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 69, "tastiness_constraint7")
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 69, "tastiness_constraint8")
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 69, "tastiness_constraint9")
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 75, "tastiness_constraint10")
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 75, "tastiness_constraint11")
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 75, "tastiness_constraint12")
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 75, "tastiness_constraint13")
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 61, "tastiness_constraint14")
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 61, "tastiness_constraint15")
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 61, "tastiness_constraint16")
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 61, "tastiness_constraint17")
m.addConstr(-7 * slices_of_pizza + 2 * cherry_pies + 8 * blueberry_pies >= 0, "tastiness_constraint18")
m.addConstr(8 * cornichons + 7 * fruit_salads <= 241, "tastiness_constraint19")
m.addConstr(8 * cornichons + 20 * cherry_pies <= 352, "tastiness_constraint20")
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies <= 278, "tastiness_constraint21")
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies <= 188, "tastiness_constraint22")
m.addConstr(7 * fruit_salads + 25 * slices_of_pizza + 20 * cherry_pies <= 336, "tastiness_constraint23")
m.addConstr(8 * cornichons + 7 * fruit_salads + 25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies <= 336, "tastiness_constraint24")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

