
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
cornichons = m.addVar(name="cornichons", lb=0)
fruit_salads = m.addVar(name="fruit_salads", lb=0)
slices_of_pizza = m.addVar(name="slices_of_pizza", lb=0)
cherry_pies = m.addVar(name="cherry_pies", lb=0)
blueberry_pies = m.addVar(name="blueberry_pies", lb=0)

# Define the objective function
m.setObjective(2.02 * cornichons + 2.38 * fruit_salads + 1.8 * slices_of_pizza + 4.35 * cherry_pies + 5.67 * blueberry_pies, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(25 * slices_of_pizza + 26 * blueberry_pies >= 28)
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 74)
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 74)
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 74)
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 74)
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 69)
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 69)
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 69)
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 69)
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 75)
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 75)
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 75)
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 75)
m.addConstr(8 * cornichons + 7 * fruit_salads + 20 * cherry_pies >= 61)
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies >= 61)
m.addConstr(8 * cornichons + 20 * cherry_pies + 26 * blueberry_pies >= 61)
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies >= 61)
m.addConstr(-7 * slices_of_pizza + 2 * cherry_pies + 8 * blueberry_pies >= 0)
m.addConstr(8 * cornichons + 7 * fruit_salads <= 241)
m.addConstr(8 * cornichons + 20 * cherry_pies <= 352)
m.addConstr(25 * slices_of_pizza + 20 * cherry_pies <= 278)
m.addConstr(8 * cornichons + 25 * slices_of_pizza + 20 * cherry_pies <= 188)
m.addConstr(7 * fruit_salads + 25 * slices_of_pizza + 20 * cherry_pies <= 336)
m.addConstr(8 * cornichons + 7 * fruit_salads + 25 * slices_of_pizza + 20 * cherry_pies + 26 * blueberry_pies <= 336)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cornichons: ", cornichons.x)
    print("Fruit Salads: ", fruit_salads.x)
    print("Slices of Pizza: ", slices_of_pizza.x)
    print("Cherry Pies: ", cherry_pies.x)
    print("Blueberry Pies: ", blueberry_pies.x)
else:
    print("The model is infeasible")
