
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
vincas = m.addVar(vtype=GRB.INTEGER, name="vincas")
tomato_vines = m.addVar(vtype=GRB.INTEGER, name="tomato_vines")
strawberry_bushes = m.addVar(vtype=GRB.INTEGER, name="strawberry_bushes")
ferns = m.addVar(vtype=GRB.INTEGER, name="ferns")

# Set objective function
m.setObjective(
    4 * vincas * vincas
    + 9 * vincas * tomato_vines
    + 9 * vincas * strawberry_bushes
    + 4 * vincas * ferns
    + 9 * tomato_vines * strawberry_bushes
    + 6 * strawberry_bushes * strawberry_bushes
    + 6 * strawberry_bushes * ferns
    + 4 * ferns * ferns
    + 2 * tomato_vines,
    GRB.MAXIMIZE,
)

# Add constraints
m.addConstr(2 * vincas + 9 * ferns >= 12, "c1")
m.addConstr(2 * vincas * vincas + 10 * strawberry_bushes * strawberry_bushes >= 22, "c2")
m.addConstr(tomato_vines + 10 * strawberry_bushes >= 9, "c3")
m.addConstr(2 * vincas + tomato_vines >= 11, "c4")
m.addConstr(10 * strawberry_bushes * strawberry_bushes + 9 * ferns * ferns >= 14, "c5")
m.addConstr(
    2 * vincas * vincas + 10 * strawberry_bushes * strawberry_bushes + 9 * ferns * ferns
    >= 17,
    "c6",
)
m.addConstr(
    2 * vincas * vincas
    + tomato_vines * tomato_vines
    + 10 * strawberry_bushes * strawberry_bushes
    >= 17,
    "c7",
)
m.addConstr(2 * vincas + 10 * strawberry_bushes + 9 * ferns >= 12, "c8")
m.addConstr(
    2 * vincas * vincas
    + tomato_vines * tomato_vines
    + 10 * strawberry_bushes * strawberry_bushes
    >= 12,
    "c9",
)

m.addConstr(2 * vincas + 10 * strawberry_bushes <= 58, "c10")
m.addConstr(2 * vincas * vincas + tomato_vines * tomato_vines <= 49, "c11")
m.addConstr(tomato_vines + 10 * strawberry_bushes <= 27, "c12")
m.addConstr(10 * strawberry_bushes * strawberry_bushes + 9 * ferns * ferns <= 82, "c13")
m.addConstr(2 * vincas + 9 * ferns <= 36, "c14")
m.addConstr(tomato_vines + 9 * ferns <= 69, "c15")
m.addConstr(2 * vincas + tomato_vines + 10 * strawberry_bushes + 9 * ferns <= 69, "c16")


# Add budget constraint
m.addConstr(
    2 * vincas + tomato_vines + 10 * strawberry_bushes + 9 * ferns <= 92, "budget"
)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vincas: {vincas.x}")
    print(f"Tomato Vines: {tomato_vines.x}")
    print(f"Strawberry Bushes: {strawberry_bushes.x}")
    print(f"Ferns: {ferns.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

