
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
protein_bars = m.addVar(lb=0, name="protein_bars")
hot_dogs = m.addVar(lb=0, name="hot_dogs")

# Set objective function
m.setObjective(5 * protein_bars**2 + 7 * hot_dogs**2 + 1 * hot_dogs, GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * protein_bars**2 + 16 * hot_dogs**2 >= 26, "fiber_constraint1")
m.addConstr(16 * protein_bars + 16 * hot_dogs >= 26, "fiber_constraint2")
m.addConstr(11 * protein_bars**2 + 1 * hot_dogs**2 >= 38, "tastiness_constraint1")
m.addConstr(11 * protein_bars + 1 * hot_dogs >= 38, "tastiness_constraint2")
m.addConstr(15 * protein_bars + 15 * hot_dogs >= 27, "umami_constraint1")
m.addConstr(1 * protein_bars + -9 * hot_dogs >= 0, "constraint1")
m.addConstr(16 * protein_bars + 16 * hot_dogs <= 66, "fiber_constraint3")
m.addConstr(11 * protein_bars + 1 * hot_dogs <= 66, "tastiness_constraint3")
m.addConstr(15 * protein_bars + 15 * hot_dogs <= 75, "umami_constraint2")


# Resource Constraints (using the provided dictionary)
resource_data = {'r0': {'description': 'grams of fiber', 'upper_bound': 80, 'x0': 16, 'x1': 16}, 'r1': {'description': 'tastiness rating', 'upper_bound': 79, 'x0': 11, 'x1': 1}, 'r2': {'description': 'umami index', 'upper_bound': 77, 'x0': 15, 'x1': 15}}

# These constraints are already included above, based on the problem description.  Including them again would be redundant.
#for resource, data in resource_data.items():
#    m.addConstr(data['x0'] * protein_bars + data['x1'] * hot_dogs <= data['upper_bound'], resource)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('protein_bars:', protein_bars.x)
    print('hot_dogs:', hot_dogs.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

