
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")

# Objective function: minimize 5*x0^2 + 7*x1^2 + x1
m.setObjective(5*x0**2 + 7*x1**2 + x1, GRB.MINIMIZE)

# Constraints
m.addConstr(16*x0**2 + 16*x1**2 >= 26, "fiber_squared")
m.addConstr(16*x0 + 16*x1 >= 26, "fiber_linear")
m.addConstr(11*x0**2 + x1**2 >= 38, "tastiness_squared")
m.addConstr(11*x0 + x1 >= 38, "tastiness_linear")
m.addConstr(15*x0 + 15*x1 >= 27, "umami_index")
m.addConstr(x0 - 9*x1 >= 0, "protein_hotdog_ratio")
m.addConstr(16*x0 + 16*x1 <= 66, "fiber_upper_bound")
m.addConstr(11*x0 + x1 <= 66, "tastiness_upper_bound")
m.addConstr(15*x0 + 15*x1 <= 75, "umami_index_upper_bound")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Protein bars: {x0.x}")
    print(f"Hot dogs: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
