
import gurobipy as gp

# Create a new model
m = gp.Model("Nutrition Problem")

# Define variables
protein_bars = m.addVar(name="protein_bars", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
hot_dogs = m.addVar(name="hot_dogs", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
m.setObjective(5 * protein_bars**2 + 7 * hot_dogs**2 + hot_dogs, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(protein_bars * 16 >= 0, "fiber_per_bar")
m.addConstr(hot_dogs * 16 >= 0, "fiber_per_hot_dog")
m.addConstr(protein_bars**2 * 16**2 + hot_dogs**2 * 16**2 >= 26, "min_fiber_squared")
m.addConstr(protein_bars * 16 + hot_dogs * 16 >= 26, "min_fiber")
m.addConstr(protein_bars * 16 + hot_dogs * 16 <= 66, "max_fiber")

m.addConstr(protein_bars * 11 >= 0, "tastiness_per_bar")
m.addConstr(hot_dogs * 1 >= 0, "tastiness_per_hot_dog")
m.addConstr(protein_bars**2 * 11**2 + hot_dogs**2 * 1**2 >= 38, "min_tastiness_squared")
m.addConstr(protein_bars * 11 + hot_dogs * 1 >= 38, "min_tastiness")
m.addConstr(protein_bars * 11 + hot_dogs * 1 <= 66, "max_tastiness")

m.addConstr(protein_bars * 15 >= 0, "umami_per_bar")
m.addConstr(hot_dogs * 15 >= 0, "umami_per_hot_dog")
m.addConstr(protein_bars * 15 + hot_dogs * 15 >= 27, "min_umami")
m.addConstr(protein_bars * 15 + hot_dogs * 15 <= 75, "max_umami")

m.addConstr(protein_bars - 9 * hot_dogs >= 0, "protein_hotdog_ratio")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Protein Bars: {protein_bars.varValue}")
    print(f"Hot Dogs: {hot_dogs.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
