
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
eggs = model.addVar(vtype=GRB.INTEGER, name="eggs")
knishes = model.addVar(vtype=GRB.INTEGER, name="knishes")
cornichons = model.addVar(vtype=GRB.INTEGER, name="cornichons")

# Set objective function
model.setObjective(4.93 * eggs**2 + 5.34 * eggs * cornichons + 1.27 * knishes**2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * eggs + 25 * knishes + 16 * cornichons <= 80, "umami_index")  # r0
model.addConstr(25 * eggs + 10 * knishes + 19 * cornichons <= 115, "healthiness_rating")  # r1
model.addConstr(2 * eggs + 3 * knishes + 13 * cornichons <= 102, "grams_of_fiber")  # r2

model.addConstr(knishes**2 + cornichons**2 >= 15, "combined_umami_1")
model.addConstr(10 * knishes + 19 * cornichons >= 28, "combined_healthiness_1")
model.addConstr(25 * eggs + 10 * knishes >= 30, "combined_healthiness_2")
model.addConstr(25 * eggs + 19 * cornichons >= 19, "combined_healthiness_3")
model.addConstr(2 * eggs + 13 * cornichons >= 29, "combined_fiber_1")
model.addConstr((2 * eggs)**2 + (16 * cornichons)**2 <= 79, "combined_umami_2")  # Note the squaring of individual coefficients
model.addConstr(2 * eggs + 25 * knishes + 16 * cornichons <= 79, "combined_umami_3")
model.addConstr(25 * eggs + 10 * knishes <= 42, "combined_healthiness_4")
model.addConstr(10 * knishes + 19 * cornichons <= 70, "combined_healthiness_5")
model.addConstr((25 * eggs)**2 + (19 * cornichons)**2 <= 91, "combined_healthiness_6")  # Note the squaring of individual coefficients
model.addConstr(25 * eggs + 10 * knishes + 19 * cornichons <= 91, "combined_healthiness_7")
model.addConstr((3 * knishes)**2 + (13 * cornichons)**2 <= 48, "combined_fiber_2")  # Note the squaring of individual coefficients
model.addConstr((2 * eggs)**2 + (13 * cornichons)**2 <= 87, "combined_fiber_3")  # Note the squaring of individual coefficients
model.addConstr(2 * eggs + 3 * knishes + 13 * cornichons <= 87, "combined_fiber_4")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('eggs:', eggs.x)
    print('knishes:', knishes.x)
    print('cornichons:', cornichons.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

