
from gurobipy import Model, GRB

# Create a new model
m = Model("Military Optimization")

# Create variables
x = {}
var_names = ['mechanized infantry companies', 'engineer platoons', 'reconnaissance troops', 
             'air defense batteries', 'water purification units', 'logistics companies']
for i in range(len(var_names)):
    x[i] = m.addVar(vtype=GRB.INTEGER, name=var_names[i])

# Set objective function
m.setObjective(4*x[0] + 3*x[1] + 2*x[2] + 4*x[3] + 4*x[4] + 2*x[5], GRB.MAXIMIZE)

# Resource data
resources = {'r0': {'description': 'deployment weight', 'upper_bound': 497, 'x0': 13, 'x1': 17, 'x2': 13, 'x3': 4, 'x4': 14, 'x5': 14}, 
             'r1': {'description': 'defensive capability rating', 'upper_bound': 343, 'x0': 15, 'x1': 12, 'x2': 3, 'x3': 5, 'x4': 9, 'x5': 3}}

# Resource constraints
m.addConstr(13*x[0] + 17*x[1] + 13*x[2] + 4*x[3] + 14*x[4] + 14*x[5] <= resources['r0']['upper_bound'], "Total Deployment Weight")
m.addConstr(15*x[0] + 12*x[1] + 3*x[2] + 5*x[3] + 9*x[4] + 3*x[5] <= resources['r1']['upper_bound'], "Total Defensive Capability")


# Additional constraints (deployment weight)
m.addConstr(13*x[0] + 13*x[2] >= 48)
m.addConstr(13*x[2] + 14*x[5] >= 67)
m.addConstr(4*x[3] + 14*x[4] >= 48)
m.addConstr(13*x[0] + 4*x[3] + 14*x[4] >= 44)
m.addConstr(17*x[1] + 4*x[3] + 14*x[5] >= 44)


# Additional constraints (defensive capability rating)
m.addConstr(15*x[0] + 12*x[1] >= 39)
m.addConstr(12*x[1] + 3*x[5] >= 20)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

