
import gurobipy as gp

# Create a new model
m = gp.Model("Employee_Hours")

# Create variables
laura_hours = m.addVar(name="laura_hours")
jean_hours = m.addVar(name="jean_hours")
ringo_hours = m.addVar(name="ringo_hours")

# Set objective function
m.setObjective(4 * laura_hours + 6 * jean_hours + 2 * ringo_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * laura_hours + 16 * ringo_hours <= 101, "paperwork_laura_ringo")
m.addConstr(15 * jean_hours + 16 * ringo_hours <= 204, "paperwork_jean_ringo")
m.addConstr(3 * laura_hours + 15 * jean_hours + 16 * ringo_hours <= 204, "paperwork_all")

m.addConstr(17 * jean_hours + 10 * ringo_hours <= 143, "computer_jean_ringo")
m.addConstr(6 * laura_hours + 17 * jean_hours <= 128, "computer_laura_jean")
m.addConstr(6 * laura_hours + 17 * jean_hours + 10 * ringo_hours <= 191, "computer_all")

m.addConstr(21 * laura_hours + 7 * ringo_hours <= 132, "productivity_laura_ringo")
m.addConstr(21 * laura_hours + 19 * jean_hours <= 160, "productivity_laura_jean")
m.addConstr(21 * laura_hours + 19 * jean_hours + 7 * ringo_hours <= 160, "productivity_all")

m.addConstr(21 * laura_hours + 7 * ringo_hours <= 69, "organization_laura_ringo")
m.addConstr(21 * laura_hours + 5 * jean_hours <= 192, "organization_laura_jean")
m.addConstr(21 * laura_hours + 5 * jean_hours + 7 * ringo_hours <= 192, "organization_all")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Ringo Hours: %g' % ringo_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

