
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
laura_hours = model.addVar(name="laura_hours", lb=0)  # No lower bound specified, assuming 0
jean_hours = model.addVar(name="jean_hours", lb=0)  # No lower bound specified, assuming 0
ringo_hours = model.addVar(name="ringo_hours", lb=0)  # No lower bound specified, assuming 0

# Objective function
model.setObjective(4 * laura_hours + 6 * jean_hours + 2 * ringo_hours, gurobi.GRB.MAXIMIZE)

# Constraints
# Individual constraints (no optimization needed for these, just setting values)
# Laura's ratings
model.addConstr(3 * laura_hours <= 270, "laura_paperwork")
model.addConstr(6 * laura_hours <= 204, "laura_computer")
model.addConstr(21 * laura_hours <= 197, "laura_productivity")
model.addConstr(21 * laura_hours <= 198, "laura_organization")

# Jean's ratings
model.addConstr(15 * jean_hours <= 270, "jean_paperwork")
model.addConstr(17 * jean_hours <= 204, "jean_computer")
model.addConstr(19 * jean_hours <= 197, "jean_productivity")
model.addConstr(5 * jean_hours <= 198, "jean_organization")

# Ringo's ratings
model.addConstr(16 * ringo_hours <= 270, "ringo_paperwork")
model.addConstr(10 * ringo_hours <= 204, "ringo_computer")
model.addConstr(7 * ringo_hours <= 197, "ringo_productivity")
model.addConstr(7 * ringo_hours <= 198, "ringo_organization")

# Combined constraints
model.addConstr(3 * laura_hours + 16 * ringo_hours <= 101, "combined_paperwork_Laura_Ringo")
model.addConstr(15 * jean_hours + 16 * ringo_hours <= 204, "combined_paperwork_Jean_Ringo")
model.addConstr(3 * laura_hours + 15 * jean_hours + 16 * ringo_hours <= 204, "combined_paperwork_all")

model.addConstr(17 * jean_hours + 10 * ringo_hours <= 143, "combined_computer_Jean_Ringo")
model.addConstr(6 * laura_hours + 17 * jean_hours <= 128, "combined_computer_Laura_Jean")
model.addConstr(6 * laura_hours + 17 * jean_hours + 10 * ringo_hours <= 191, "combined_computer_all")

model.addConstr(21 * laura_hours + 7 * ringo_hours <= 132, "combined_productivity_Laura_Ringo")
model.addConstr(21 * laura_hours + 19 * jean_hours <= 160, "combined_productivity_Laura_Jean")
model.addConstr(21 * laura_hours + 19 * jean_hours + 7 * ringo_hours <= 160, "combined_productivity_all")

model.addConstr(21 * laura_hours + 7 * ringo_hours <= 69, "combined_organization_Laura_Ringo")
model.addConstr(21 * laura_hours + 5 * jean_hours <= 192, "combined_organization_Laura_Jean")
model.addConstr(21 * laura_hours + 5 * jean_hours + 7 * ringo_hours <= 192, "combined_organization_all")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Laura hours: {laura_hours.varValue}")
    print(f"Jean hours: {jean_hours.varValue}")
    print(f"Ringo hours: {ringo_hours.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
