
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
headsets = model.addVar(vtype=GRB.INTEGER, name="headsets")
packs_of_paper = model.addVar(vtype=GRB.INTEGER, name="packs_of_paper")

# Set objective function
model.setObjective(6 * headsets * packs_of_paper + 4 * headsets, GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * headsets + 17 * packs_of_paper >= 30, "sustainability_lower_bound")
model.addConstr(13 * headsets + 11 * packs_of_paper >= 55, "usefulness_lower_bound")
model.addConstr(-2 * headsets + 1 * packs_of_paper >= 0, "constraint_3")
model.addConstr(15*15*headsets*headsets + 17*17*packs_of_paper*packs_of_paper <= 68, "sustainability_squared_upper_bound") #note: this constraint makes the problem infeasible as x0,x1 >=0
model.addConstr(15 * headsets + 17 * packs_of_paper <= 68, "sustainability_upper_bound")
model.addConstr(13 * headsets + 11 * packs_of_paper <= 85, "usefulness_upper_bound")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Number of headsets: {headsets.x}")
    print(f"Number of packs of paper: {packs_of_paper.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

