
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
headsets = m.addVar(vtype=GRB.INTEGER, name="headsets")
packs_of_paper = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper")

# Objective function: Maximize 6 * headsets * packs_of_paper + 4 * headsets
m.setObjective(6 * headsets * packs_of_paper + 4 * headsets, GRB.MAXIMIZE)

# Constraints
# 1. Sustainability score constraint
m.addConstr(15 * headsets + 17 * packs_of_paper >= 30, name="sustainability_score")

# 2. Usefulness rating constraint
m.addConstr(13 * headsets + 11 * packs_of_paper >= 55, name="usefulness_rating")

# 3. Mixed constraint
m.addConstr(-2 * headsets + 1 * packs_of_paper >= 0, name="mixed_constraint")

# 4. Corrected sustainability score constraint (linear interpretation)
m.addConstr(15 * headsets + 17 * packs_of_paper <= 68, name="sustainability_score_upper_bound")

# 5. Combined usefulness rating constraint (upper bound)
m.addConstr(13 * headsets + 11 * packs_of_paper <= 85, name="usefulness_rating_upper_bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Headsets: {headsets.x}")
    print(f"Packs of Paper: {packs_of_paper.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
